% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vwhs.R
\name{vwhs}
\alias{vwhs}
\title{Volatility weighted historical simulation}
\usage{
vwhs(x, p = 0.95, lambda = 0.94)
}
\arguments{
\item{x}{a numeric vector of asset returns}

\item{p}{confidence level for VaR calculation; default is 0.95\%}

\item{lambda}{decay factor for the calculation of weights; default is 0.94}
}
\value{
Returns a list with the following elements:
\describe{
\item{VaR}{Calculated Value at Risk}
\item{ES}{Calculated Expected Shortfall}
}
}
\description{
Calculates univariate Value at Risk and Expected Shortfall by means
of volatility weighted historical simulation. Volatility is
estimated with an exponentially weighted moving average.
}
\examples{
prices <- DAX30$price.close
returns <- diff(log(prices))
vwhs(x = returns, p = 0.95, lambda = 0.94)
}
