% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render.R
\name{quarto_render}
\alias{quarto_render}
\title{Render Markdown}
\usage{
quarto_render(
  input = NULL,
  output_format = NULL,
  output_file = NULL,
  execute = TRUE,
  execute_params = NULL,
  execute_dir = NULL,
  execute_daemon = NULL,
  execute_daemon_restart = FALSE,
  execute_debug = FALSE,
  use_freezer = FALSE,
  cache = NULL,
  cache_refresh = FALSE,
  metadata = NULL,
  metadata_file = NULL,
  debug = FALSE,
  quiet = FALSE,
  profile = NULL,
  quarto_args = NULL,
  pandoc_args = NULL,
  as_job = getOption("quarto.render_as_job", "auto")
)
}
\arguments{
\item{input}{The input file or project directory to be rendered (defaults
to rendering the project in the current working directory).}

\item{output_format}{Target output format (defaults to \code{"html"}). The option
\code{"all"} will render all formats defined within the file or project.}

\item{output_file}{The name of the output file. If using \code{NULL}, the output
filename will be based on the filename for the input file. \code{output_file} is
mapped to the \code{--output} option flag of the \code{quarto} CLI. It is expected to
be a filename only, not a path, relative or absolute.}

\item{execute}{Whether to execute embedded code chunks.}

\item{execute_params}{A list of named parameters that override custom params
specified within the YAML front-matter.}

\item{execute_dir}{The working directory in which to execute embedded code
chunks.}

\item{execute_daemon}{Keep Jupyter kernel alive (defaults to 300 seconds).
Note this option is only applicable for rendering Jupyter notebooks or
Jupyter markdown.}

\item{execute_daemon_restart}{Restart keepalive Jupyter kernel before render.
Note this option is only applicable for rendering Jupyter notebooks or
Jupyter markdown.}

\item{execute_debug}{Show debug output for Jupyter kernel.}

\item{use_freezer}{Force use of frozen computations for an incremental
file render.}

\item{cache}{Cache execution output (uses knitr cache and jupyter-cache
respectively for Rmd and Jupyter input files).}

\item{cache_refresh}{Force refresh of execution cache.}

\item{metadata}{An optional named list used to override YAML
metadata. It will be passed as a YAML file to \code{--metadata-file} CLI flag.
This will be merged over \code{metadata-file} options if both are
specified.}

\item{metadata_file}{A yaml file passed to \code{--metadata-file} CLI flags to
override metadata. This will be merged with \code{metadata} if both are
specified, with low precedence on \code{metadata} options.}

\item{debug}{Leave intermediate files in place after render.}

\item{quiet}{Suppress warning and other messages.}

\item{profile}{\href{https://quarto.org/docs/projects/profiles.html}{Quarto project profile(s)} to use. Either
a character vector of profile names or \code{NULL} to use the default profile.}

\item{quarto_args}{Character vector of other \code{quarto} CLI arguments to append
to the Quarto command executed by this function. This is mainly intended for
advanced usage and useful for CLI arguments which are not yet mirrored in a
dedicated parameter of this \R function. See \verb{quarto render --help} for options.}

\item{pandoc_args}{Additional command line arguments to pass on to Pandoc.}

\item{as_job}{Render as an RStudio background job. Default is \code{"auto"},
which will render individual documents normally and projects as
background jobs. Use the \code{quarto.render_as_job} \R option to control
the default globally.}
}
\description{
Render the input file to the specified output format using quarto. If the
input requires computations (e.g. for Rmd or Jupyter files) then those
computations are performed before rendering.
}
\examples{
\dontrun{
# Render R Markdown
quarto_render("notebook.Rmd")
quarto_render("notebook.Rmd", output_format = "pdf")

# Render Jupyter Notebook
quarto_render("notebook.ipynb")

# Render Jupyter Markdown
quarto_render("notebook.md")

# Override metadata
quarto_render("notebook.Rmd", metadata = list(lang = "fr", execute = list(echo = FALSE)))
}
}
