% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reg.R
\name{reg}
\alias{reg}
\title{Apply univariate regression models}
\usage{
reg(data = NULL, x = NULL, y = NULL, factor = NULL, model = NULL,
  time = NULL, ...)
}
\arguments{
\item{data}{A data.frame}

\item{x}{Column indices or names of the variables to be included in univariate analysis, the default columns are all the variables except dependent}

\item{y}{Column indice of dependent variable or name}

\item{factor}{Column indices of the variables or names to be treated as factor}

\item{model}{Univariate analysis method, see \code{\link{lm}}, \code{\link{glm}}, \code{\link[survival]{coxph}}}

\item{time}{Column indice of survival time or name, used in cox regression, see \code{\link[survival]{coxph}} for more details}

\item{\dots}{Further arguments passed to regression model}
}
\value{
The return result is a list including two componets, the first part is a detailed anaysis result, the second part is a concentrated result in a  data.frame
}
\description{
Apply general linear model, generalized linear model, cox regression model,etc.
}
\examples{
reg_glm<-reg(data = diabetes, x = c(1:4, 6), y = 5, factor = c(1, 3, 4), model = 'glm')
##  subset result like a list
reg_glm$detail
reg_glm$dataframe
reg_glm[2]
reg_glm$detail[2:4]
##  other methods
reg(data = diabetes, x = c(1, 3:6), y = 10, factor = c(1, 3, 4), model = 'lm')
reg(data = diabetes, x = c( "sex","education","BMI"), y = "diabetes",
time ="age", factor = c("sex","smoking","education"), model = 'coxph')
}

