% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qb_blocking.R
\name{qb_blocking}
\alias{qb_blocking}
\title{Constructor for qb_blocking objects}
\usage{
qb_blocking(block_labels, unassigned_labels = NULL, ids = NULL)
}
\arguments{
\item{block_labels}{a vector containing each unit's block label.}

\item{unassigned_labels}{labels that denote unassigned units. If \code{NULL}, \code{NA} values in
\code{block_labels} are used to denote unassigned units.}

\item{ids}{IDs of the units. Should be a vector of the same length as
\code{block_labels} or \code{NULL}. If \code{NULL}, the IDs are set to
\code{1:length(group_labels)}.}
}
\value{
Returns a \code{qb_blocking} object with the blocking described by the
   provided labels.
}
\description{
The \code{qb_blocking} function constructs a \code{qb_blocking} object from
existing block labels. The function does not derive blockings from
sets of data points; see \code{\link{quickblock}} for that functionality.
}
\details{
\code{qb_blocking} objects are based on integer vectors, and it indexes
the blocks starting with zero. The \code{qb_blocking} class inherits
from the \code{\link[scclust]{scclust}} class.
}
\examples{
# 10 units in 3 blocks
blocking1 <- qb_blocking(c("A", "A", "B", "C", "B",
                           "C", "C", "A", "B", "B"))

# 8 units in 3 blocks, 2 units unassigned
blocking2 <- qb_blocking(c(1, 1, 2, 3, 2,
                           NA, 3, 1, NA, 2))

# Custom labels indicating unassigned units
blocking3 <- qb_blocking(c("A", "A", "B", "C", "NONE",
                           "C", "C", "NONE", "B", "B"),
                        unassigned_labels = "NONE")

# Two different labels indicating unassigned units
blocking4 <- qb_blocking(c("A", "A", "B", "C", "NONE",
                           "C", "C", "0", "B", "B"),
                        unassigned_labels = c("NONE", "0"))

# Custom unit IDs
blocking5 <- qb_blocking(c("A", "A", "B", "C", "B",
                           "C", "C", "A", "B", "B"),
                        ids = letters[1:10])

}
