#' List generator
#'
#' Generate lists with contents corresponding to the values generated by the
#' input generators.
#'
#' @param ... A set of named or unnamed generators.
#'
#' @examples
#' list_(integer_(), logical_()) |> show_example()
#' list_(a = any_vector(), b = any_vector()) |> show_example()
#' @template generator
#' @export
list_ <- function(...) {
  qc_gen(\()
    hedgehog::gen.with(
      eval_functions(...),
      as.list
    )
  )
}

#' Variable length list generator
#'
#' Generate lists with all values coming from a single generator.
#'
#' @template param_generator
#' @template len
#'
#' @examples
#' list_of(integer_(), len = 10L) |> show_example()
#' @template generator
#' @export
list_of <- function(generator, len = c(1L, 10L)) {
  qc_gen(\(len2 = len)
    vectorize(list(generator()), len2)
  )
}

#' Variable length flat list generator
#'
#' Generate flat lists with all values coming from a single generator. In a flat
#' list all items will be scalars.
#'
#' @template param_generator
#' @template len
#'
#' @examples
#' flat_list_of(integer_(), len = 10L) |> show_example()
#' @template generator
#' @export
flat_list_of <- function(generator, len = c(1L, 10L)) {
  qc_gen(\(len2 = len)
    vectorize(list(generator(len = 1L)), len2)
  )
}
