% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date.R
\name{date_}
\alias{date_}
\alias{date_bounded}
\alias{date_left_bounded}
\alias{date_right_bounded}
\title{Date generators}
\usage{
date_(len = c(1L, 10L), any_na = FALSE)

date_bounded(left, right, len = c(1L, 10L), any_na = FALSE)

date_left_bounded(left, len = c(1L, 10L), any_na = FALSE)

date_right_bounded(right, len = c(1L, 10L), any_na = FALSE)
}
\arguments{
\item{len}{Length of the generated vectors. If \code{len} is a
single number all vectors will have this length. If
\code{len} is a numeric vector of length 2 it will produce
vectors with lengths between a minimum and maximum,
inclusive. For example \code{len = c(1L, 10L)} would produce
vectors with lengths between 1 and 10. To produce empty vectors
set \code{len = 0L} or a range like \code{len = c(0L, 10L)}.}

\item{any_na}{Whether \code{NA} values should be allowed.}

\item{left}{The minimum possible value for generated
numbers, inclusive.}

\item{right}{The maximum possible value for generated
numbers, inclusive.}
}
\value{
A \code{quickcheck_generator} object.
}
\description{
A set of generators for date vectors.
}
\examples{
date_() |> show_example()
date_bounded(
  left = as.Date("2020-01-01"),
  right = as.Date("2020-01-10")
) |> show_example()
date_(len = 10L, any_na = TRUE) |> show_example()
}
