% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean.R
\name{clean}
\alias{clean}
\title{Clear environment, clear console, set work directory and load files}
\usage{
clean(setwd = NULL, source = c(), load = c(), clearPkgs = FALSE)
}
\arguments{
\item{setwd}{OPTIONAL. set working directory}

\item{source}{OPTIONAL. source in file(s)}

\item{load}{OPTIONAL. load in Rdata file(s)}

\item{clearPkgs}{Clear previous loaded packages, TRUE or FALSE}
}
\value{
cleared environment and set directory
}
\description{
Shorthand to quickly clear console, clear environment, set working directory, load files
}
\details{
The purpose of this function is provide a one-line code to clear the console, clear the environment,
set working directory to a specified path, source in various files into the current file, and
load RData files into the current environment. The first process in the sequence of events is to clear the
environment. Then the working directory is set, prior to inclusion of various files and RData. With the directory
being set first, the path to the sourced in or RData files will not need to be appended to the file name. See examples.
}
\examples{
\donttest{
#simply clear environment, clear console and devices
quickcode::clean()

#clear combined with additional arguments
quickcode::clean(
  clearPkgs = FALSE
) #also clear all previously loaded packages if set to true

quickcode::clean(
  setwd = "/home/"
) #clear env and also set working directory


quickcode::clean(
  source = c("/home/file1.R","file2")
) #clear environment and source two files into current document


quickcode::clean(
  setwd = "/home/",
  source = c("file1","file2")
) #clear environment, set working directory and source 2 files into environment


quickcode::clean(
  setwd = "/home/",
  source="file1.R",
  load="obi.RData"
) #clear environment, set working directory, source files and load RData
}

}
