% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotcurves_.R
\name{plotcurves_}
\alias{plotcurves_}
\title{Plot the curves}
\usage{
plotcurves_(qp, panel = NULL, xpanel = NULL, ypanel = NULL,
  color = NULL, averages = TRUE, curves = TRUE, thresholds = TRUE,
  ci = TRUE)
}
\arguments{
\item{qp}{output from quickpsy}

\item{panel}{Name of the variable to be split in panels.}

\item{xpanel}{Name of the variable to be split in horizontal panels.}

\item{ypanel}{Name of the variable to be split in vertical panels.}

\item{color}{Name of the variable codded by color.}

\item{averages}{If \code{FALSE} averaged probabilities are not plotted
(default is \code{TRUE}).}

\item{curves}{If \code{FALSE} curves are not plotted
(default is \code{TRUE})}

\item{thresholds}{If \code{FALSE} thresholds  are not plotted
(default is \code{TRUE})}

\item{ci}{If \code{FALSE} confidence intervals are not plotted
(default is \code{TRUE})}
}
\description{
\code{plotcurves_} is the standard evaluation SE function associated
to the non-standard evaluation NSE function \code{plotcurves}.
\href{http://adv-r.had.co.nz/Computing-on-the-language.html}{SE functions can be more easily called from other functions.}
In SE functions, you need to quote the names of the variables.
}
\examples{
library(MPDiR) # contains the Vernier data
data(Vernier) # ?Venier for the reference
fit <- quickpsy(Vernier, Phaseshift, NumUpward, N,
                grouping = .(Direction, WaveForm, TempFreq), B = 5)

plotcurves_(fit, xpanel = 'Direction')
plotcurves_(fit, color = 'Direction')
plotcurves_(fit, xpanel = 'Direction', color = 'WaveForm', ci = FALSE)
}
\seealso{
\code{\link{plotcurves}}
}

