% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-performance_metrics.R
\docType{class}
\name{performance_metrics-class}
\alias{performance_metrics-class}
\title{An S4 class to represent a set of PGS Catalog Performance Metrics}
\description{
The performance_metrics object consists of nine tables (slots) that combined
form a relational database of a subset of performance metrics. Each
performance metric is an observation (row) in the \code{scores} table (first
table).
}
\section{Slots}{

\describe{
\item{\code{performance_metrics}}{A table of PGS Performance Metrics (PPM). Each PPM (row) is
uniquely identified by the \code{ppm_id} column. Columns:
\describe{
\item{ppm_id}{A PGS Performance Metrics identifier. Example: \code{"PPM000001"}.}
\item{pgs_id}{Polygenic Score (PGS) identifier.}
\item{reported_trait}{The author-reported trait that the PGS has been
developed to predict. Example: \code{"Breast Cancer"}.}
\item{covariates}{Comma-separated list of covariates used in the prediction
model to evaluate the PGS.}
\item{comments}{Any other information relevant to the understanding of the
performance metrics.}
}}

\item{\code{publications}}{A table of publications. Each publication (row) is
uniquely identified by the column \code{pgp_id}. Columns:
\describe{
\item{ppm_id}{A PGS Performance Metrics identifier. Example: \code{"PPM000001"}.}
\item{pgp_id}{PGS Publication identifier. Example: \code{"PGP000001"}.}
\item{pubmed_id}{\href{https://en.wikipedia.org/wiki/PubMed}{PubMed}
identifier. Example: \code{"25855707"}.}
\item{publication_date}{Publication date. Example: \code{"2020-09-28"}. Note
that the class of \code{publication_date} is \code{\link[base]{Date}}.}
\item{publication}{Abbreviated name of the journal. Example: \code{"Am J Hum
Genet"}.}
\item{title}{Publication title.}
\item{author_fullname}{First author of the publication. Example:
\code{'Mavaddat N'}.}
\item{doi}{Digital Object Identifier (DOI). This variable is also curated to
allow unpublished work (e.g. preprints) to be added to the catalog. Example:
\code{"10.1093/jnci/djv036"}.}
}}

\item{\code{sample_sets}}{A table of sample sets. Each sample set (row) is uniquely
identified by the column \code{pss_id}. Columns:
\describe{
\item{ppm_id}{A PGS Performance Metrics identifier. Example: \code{"PPM000001"}.}
\item{pss_id}{A PGS Sample Set identifier. Example: \code{"PSS000042"}.}
}}

\item{\code{samples}}{A table of samples. Each sample (row) is uniquely identified by
the combination of values from the columns: \code{ppm_id}, \code{pss_id},
and \code{sample_id}. Columns:
\describe{
\item{ppm_id}{A PGS Performance Metrics identifier. Example: \code{"PPM000001"}.}
\item{pss_id}{A PGS Sample Set identifier. Example: \code{"PSS000042"}.}
\item{sample_id}{Sample identifier. This is a surrogate key to identify each sample.}
\item{stage}{Sample stage: should be always Evaluation (\code{"eval"}).}
\item{sample_size}{Number of individuals included in the sample.}
\item{sample_cases}{Number of cases.}
\item{sample_controls}{Number of controls.}
\item{sample_percent_male}{Percentage of male participants.}
\item{phenotype_description}{Detailed phenotype description.}
\item{ancestry_category}{Author reported ancestry is mapped to the best matching
ancestry category from the NHGRI-EBI GWAS Catalog framework (see
\code{\link[quincunx]{ancestry_categories}}) for possible values.}
\item{ancestry}{A more detailed description of sample ancestry
that usually matches the most specific description described by the authors
(e.g. French, Chinese).}
\item{country}{Author reported countries of recruitment (if available).}
\item{ancestry_additional_description}{Any additional description not
captured in the other columns (e.g. founder or genetically isolated
populations, or further description of admixed samples).}
\item{study_id}{Associated GWAS Catalog study accession identifier, e.g.,
\code{"GCST002735"}.}
\item{pubmed_id}{\href{https://en.wikipedia.org/wiki/PubMed}{PubMed}
identifier.}
\item{cohorts_additional_description}{Any additional description about the
samples (e.g. sub-cohort information).}
}}

\item{\code{demographics}}{A table of sample demographics' variables. Each
demographics' variable (row) is uniquely identified by the combination of
values from the columns: \code{ppm_id}, \code{pss_id}, \code{sample_id},
and \code{variable}. Columns:
\describe{
\item{ppm_id}{A PGS Performance Metrics identifier. Example: \code{"PPM000001"}.}
\item{pss_id}{A PGS Sample Set identifier. Example: \code{"PSS000042"}.}
\item{sample_id}{Sample identifier. This is a surrogate identifier to
identify each sample.}
\item{variable}{Demographics variable. Following columns report about the
indicated variable.}
\item{estimate_type}{Type of statistical estimate for variable.}
\item{estimate}{The variable's statistical value.}
\item{unit}{Unit of the variable.}
\item{variability_type}{Measure of statistical dispersion for variable, e.g.
standard error (se) or standard deviation (sd).}
\item{variability}{The value of the measure of dispersion.}
\item{interval_type}{Type of statistical interval for variable: range, iqr
(interquartile), ci (confidence interval).}
\item{interval_lower}{Interval lower bound.}
\item{interval_upper}{Interval upper bound.}
}}

\item{\code{cohorts}}{A table of cohorts. Each cohort (row) is uniquely identified by
the combination of values from the columns: \code{ppm_id}, \code{sample_id}
and \code{cohort_symbol}. Columns:
\describe{
\item{ppm_id}{A PGS Performance Metrics identifier. Example: \code{"PPM000001"}.}
\item{sample_id}{Sample identifier. This is a surrogate key to identify each sample.}
\item{cohort_symbol}{Cohort symbol.}
\item{cohort_name}{Cohort full name.}
}}

\item{\code{pgs_effect_sizes}}{A table of effect sizes per standard deviation change
in PGS. Examples include regression coefficients (betas) for continuous
traits, odds ratios (OR) and/or hazard ratios (HR) for dichotomous traits
depending on the availability of time-to-event data. Each effect size is
uniquely identified by the combination of values from the columns:
\code{ppm_id} and \code{effect_size_id}. Columns:
\describe{
\item{ppm_id}{A PGS Performance Metrics identifier. Example: \code{"PPM000001"}.}
\item{effect_size_id}{Effect size identifier. This is a surrogate identifier to
identify each effect size.}
\item{estimate_type_long}{Long notation of the effect size (e.g. Odds Ratio).}
\item{estimate_type}{Short notation of the effect size (e.g. OR).}
\item{estimate}{The estimate's value.}
\item{unit}{Unit of the estimate.}
\item{variability_type}{Measure of statistical dispersion for variable, e.g.
standard error (se) or standard deviation (sd).}
\item{variability}{The value of the measure of dispersion.}
\item{interval_type}{Type of statistical interval for variable: range, iqr
(interquartile), ci (confidence interval).}
\item{interval_lower}{Interval lower bound.}
\item{interval_upper}{Interval upper bound.}
}}

\item{\code{pgs_classification_metrics}}{A table of classification metrics. Examples
include the Area under the Receiver Operating Characteristic (AUROC) or
Harrell's C-index (Concordance statistic). Columns:
\describe{
\item{ppm_id}{A PGS Performance Metrics identifier. Example: \code{"PPM000001"}.}
\item{classification_metrics_id}{Classification metric identifier. This is a
surrogate identifier to identify each classification metric.}
\item{estimate_type_long}{Long notation of the classification metric (e.g.
Concordance Statistic).}
\item{estimate_type}{Short notation classification metric (e.g. C-index).}
\item{estimate}{The estimate's value.}
\item{unit}{Unit of the estimate.}
\item{variability_type}{Measure of statistical dispersion for variable, e.g.
standard error (se) or standard deviation (sd).}
\item{variability}{The value of the measure of dispersion.}
\item{interval_type}{Type of statistical interval for variable: range, iqr
(interquartile), ci (confidence interval).}
\item{interval_lower}{Interval lower bound.}
\item{interval_upper}{Interval upper bound.}
}}

\item{\code{pgs_other_metrics}}{A table of other metrics that are neither effect
sizes nor classification metrics. Examples include: R² (proportion of the
variance explained), or reclassification metrics. Columns:
\describe{
\item{ppm_id}{A PGS Performance Metrics identifier. Example: \code{"PPM000001"}.}
\item{other_metrics_id}{Other metric identifier. This is a
surrogate identifier to identify each metric.}
\item{estimate_type_long}{Long notation of the metric. Example: "Proportion of the variance explained".}
\item{estimate_type}{Short notation metric. Example: "R²".}
\item{estimate}{The estimate's value.}
\item{unit}{Unit of the estimate.}
\item{variability_type}{Measure of statistical dispersion for variable, e.g.
standard error (se) or standard deviation (sd).}
\item{variability}{The value of the measure of dispersion.}
\item{interval_type}{Type of statistical interval for variable: range, iqr
(interquartile), ci (confidence interval).}
\item{interval_lower}{Interval lower bound.}
\item{interval_upper}{Interval upper bound.}
}}
}}

