% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.interaction.R
\name{summary.interaction}
\alias{summary.interaction}
\title{Summary Method for Interaction Class Objects}
\usage{
\method{summary}{interaction}(object, ...)
}
\arguments{
\item{object}{An object of class \code{interaction} that contains CD4
lymphocyte and viral load differences (raw and log-transformed).}

\item{...}{Additional arguments (currently not used).}
}
\value{
A list with the following components:
\describe{
\item{\code{cd_diff_raw}}{Summary statistics for the raw differences in CD4 lymphocyte counts.}
\item{\code{cd_diff_standardized}}{Summary statistics for the standardized CD4 lymphocyte differences.}
\item{\code{vl_diff_raw}}{Summary statistics for the raw differences in viral loads.}
\item{\code{vl_diff_log_transformed}}{Summary statistics for the log-transformed viral load differences.}
\item{\code{vl_diff_log_standardized}}{Summary statistics for the standardized log-transformed viral load differences.}
}
}
\description{
This function provides a summary of various statistics for an interaction
object, including raw and standardized differences for CD4 lymphocyte counts
and viral loads. It returns a structured list of summary statistics, useful
for understanding the differences in immune response and viral suppression
between HIV phenotypes.
}
\examples{
data(cd_3)
data(vl_3)
interaction_obj <- create_interactions(cd_3, vl_3)
summary(interaction_obj)
}
