% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/region_isos_demo.R
\docType{data}
\name{region_isos_demo}
\alias{region_isos_demo}
\title{A dataset outlining various region definitions}
\format{
An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 358 rows and 3 columns.
}
\usage{
region_isos_demo
}
\description{
This dataset maps codes representing countries to regions. It is similar to
but smaller than \link{region_isos}.

Demo datasets are synthetic because most financial data is strictly private;
they help to demonstrate and test the implementation in R of 'PACTA'
(\url{https://2degrees-investing.org/resource/pacta/}).

For information about the ISO standard for country codes see
\url{https://www.iso.org/iso-3166-country-codes.html}.
}
\section{Definitions}{

\itemize{
\item \code{isos} (character): Countries in region, defined by iso code.
\item \code{region} (character): Benchmark region name.
\item \code{source} (character): Source publication from which the regions are defined.
}
}

\examples{
region_isos_demo
}
\seealso{
Other iso codes: 
\code{\link{iso_codes}},
\code{\link{region_isos}}

Other demo datasets: 
\code{\link{abcd_demo}},
\code{\link{co2_intensity_scenario_demo}},
\code{\link{loanbook_demo}},
\code{\link{overwrite_demo}},
\code{\link{scenario_demo_2020}}
}
\concept{demo datasets}
\concept{iso codes}
\keyword{datasets}
