% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_techmix.R
\name{plot_techmix}
\alias{plot_techmix}
\title{Create a techmix plot}
\usage{
plot_techmix(data)
}
\arguments{
\item{data}{A data frame. Requirements:
\itemize{
\item The structure must be like \link{market_share}.
\item The following columns must have a single value: \code{sector}, \code{region},
\code{scenario_source}.
\item The column \code{metric} must have a portfolio (e.g. "projected"), a benchmark
(e.g. "corporate_economy"), and a single \code{scenario} (e.g. "target_sds").
}}
}
\value{
An object of class "ggplot".
}
\description{
Create a techmix plot
}
\examples{
# `data` must meet documented "Requirements"
data <- subset(
  market_share,
  scenario_source == "demo_2020" &
    sector == "power" &
    region == "global" &
    metric \%in\% c("projected", "corporate_economy", "target_sds")
)

plot_techmix(data)
}
\seealso{
\link{market_share}.
}
