% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_trajectory.R
\name{plot_trajectory}
\alias{plot_trajectory}
\title{Create a trajectory plot}
\usage{
plot_trajectory(data)
}
\arguments{
\item{data}{A data frame. Requirements:
\itemize{
\item The structure must be like \link{market_share}.
\item The following columns must have a single value: \code{sector}, \code{technology},
\code{region}, \code{scenario_source}.
\item (Optional) If present, the column \code{label} is used for data labels.
}}
}
\value{
An object of class "ggplot".
}
\description{
Create a trajectory plot
}
\examples{
# `data` must meet documented "Requirements"
data <- subset(
  market_share,
  sector == "power" &
    technology == "renewablescap" &
    region == "global" &
    scenario_source == "demo_2020"
)

plot_trajectory(data)
}
\seealso{
\link{market_share}.
}
