% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_r2_Function.R
\name{plot.R2}
\alias{plot.R2}
\title{Visualize standardized effect sizes and model R squared}
\usage{
\method{plot}{R2}(x, y = NULL, txtsize = 10, maxcov = 3, r2labs = NULL,
  r2mthd = "sgv", cor = TRUE, ...)
}
\arguments{
\item{x}{An R2 object from the r2beta function.}

\item{y}{An R2 object from the r2beta function.}

\item{txtsize}{The text size of the axis labels.}

\item{maxcov}{Maximum number of covariates to include in the semi-partial plots.}

\item{r2labs}{a character vector containing labels for the models. The labels are printed as subscripts on a covariance model matrix.}

\item{r2mthd}{The method used to compute R2}

\item{cor}{An argument to be passed to the r2dt function. Only relevant if comparing two R2 objects.}

\item{...}{Arguments to be passed to plot}
}
\value{
A visual representation of the model and semi-partial R squared
from the r2 object provided.
}
\description{
Visualize standardized effect sizes and model R squared
}
\examples{
library(nlme)
library(r2glmm)

data(Orthodont)

# Linear mixed model
lmemod = lme(distance ~ age*Sex, random = ~1|Subject, data = Orthodont)

r2 = r2beta(model=lmemod,partial=TRUE,method='sgv')

plot(x=r2)
}
