/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter.general_regression;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.general_regression.CovariateList;
import org.dmg.pmml.general_regression.FactorList;
import org.dmg.pmml.general_regression.GeneralRegressionModel;
import org.dmg.pmml.general_regression.PCell;
import org.dmg.pmml.general_regression.PPCell;
import org.dmg.pmml.general_regression.PPMatrix;
import org.dmg.pmml.general_regression.ParamMatrix;
import org.dmg.pmml.general_regression.Parameter;
import org.dmg.pmml.general_regression.ParameterList;
import org.dmg.pmml.general_regression.Predictor;
import org.dmg.pmml.general_regression.PredictorList;
import org.jpmml.converter.BinaryFeature;
import org.jpmml.converter.BooleanFeature;
import org.jpmml.converter.ConstantFeature;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.InteractionFeature;
import org.jpmml.converter.PowerFeature;
import org.jpmml.converter.ProductFeature;
import org.jpmml.converter.ValueUtil;

public class GeneralRegressionModelUtil {
    private GeneralRegressionModelUtil() {
    }

    public static GeneralRegressionModel encodeRegressionTable(GeneralRegressionModel generalRegressionModel, List<? extends Feature> features, List<Double> coefficients, Double intercept, Object targetCategory) {
        ParamMatrix paramMatrix;
        PPMatrix ppMatrix;
        if (features.size() != coefficients.size()) {
            throw new IllegalArgumentException();
        }
        ParameterList parameterList = generalRegressionModel.getParameterList();
        if (parameterList == null) {
            parameterList = new ParameterList();
            generalRegressionModel.setParameterList(parameterList);
        }
        if ((ppMatrix = generalRegressionModel.getPPMatrix()) == null) {
            ppMatrix = new PPMatrix();
            generalRegressionModel.setPPMatrix(ppMatrix);
        }
        if ((paramMatrix = generalRegressionModel.getParamMatrix()) == null) {
            paramMatrix = new ParamMatrix();
            generalRegressionModel.setParamMatrix(paramMatrix);
        }
        int p = parameterList.getParameters().size();
        if (intercept != null && !ValueUtil.isZeroLike(intercept)) {
            Parameter parameter = new Parameter("p" + String.valueOf(p)).setLabel("(intercept)");
            parameterList.addParameters(new Parameter[]{parameter});
            ++p;
            PCell pCell = new PCell(parameter.getName(), intercept.doubleValue()).setTargetCategory(targetCategory);
            paramMatrix.addPCells(new PCell[]{pCell});
        }
        LinkedHashSet<FieldName> covariates = new LinkedHashSet<FieldName>();
        LinkedHashSet<FieldName> factors = new LinkedHashSet<FieldName>();
        for (int i = 0; i < features.size(); ++i) {
            Feature feature = features.get(i);
            Double coefficient = coefficients.get(i);
            if (coefficient == null || ValueUtil.isZeroLike(coefficient)) continue;
            if (feature instanceof ProductFeature) {
                ProductFeature productFeature = (ProductFeature)feature;
                feature = productFeature.getFeature();
                coefficient = productFeature.getFactor().doubleValue() * coefficient;
            }
            Parameter parameter = new Parameter("p" + String.valueOf(p));
            parameterList.addParameters(new Parameter[]{parameter});
            ++p;
            double multiplier = GeneralRegressionModelUtil.createPPCells(feature, parameter, ppMatrix, covariates, factors);
            if (multiplier != 1.0) {
                coefficient = multiplier * coefficient;
            }
            PCell pCell = new PCell(parameter.getName(), coefficient.doubleValue()).setTargetCategory(targetCategory);
            paramMatrix.addPCells(new PCell[]{pCell});
        }
        if (covariates.size() > 0) {
            CovariateList covariateList = generalRegressionModel.getCovariateList();
            if (covariateList == null) {
                covariateList = new CovariateList();
                generalRegressionModel.setCovariateList(covariateList);
            }
            GeneralRegressionModelUtil.createPredictors((PredictorList)covariateList, covariates);
        }
        if (factors.size() > 0) {
            FactorList factorList = generalRegressionModel.getFactorList();
            if (factorList == null) {
                factorList = new FactorList();
                generalRegressionModel.setFactorList(factorList);
            }
            GeneralRegressionModelUtil.createPredictors((PredictorList)factorList, factors);
        }
        return generalRegressionModel;
    }

    private static double createPPCells(Feature feature, Parameter parameter, PPMatrix ppMatrix, Set<FieldName> covariates, Set<FieldName> factors) {
        if (feature instanceof BinaryFeature) {
            BinaryFeature binaryFeature = (BinaryFeature)feature;
            return GeneralRegressionModelUtil.createPPCell(binaryFeature.getValue(), binaryFeature.getName(), parameter, ppMatrix, factors);
        }
        if (feature instanceof BooleanFeature) {
            BooleanFeature booleanFeature = (BooleanFeature)feature;
            return GeneralRegressionModelUtil.createPPCell("true", booleanFeature.getName(), parameter, ppMatrix, factors);
        }
        if (feature instanceof ConstantFeature) {
            ConstantFeature constantFeature = (ConstantFeature)feature;
            return constantFeature.getValue().doubleValue();
        }
        if (feature instanceof InteractionFeature) {
            InteractionFeature interactionFeature = (InteractionFeature)feature;
            double result = 1.0;
            List<? extends Feature> inputFeatures = interactionFeature.getInputFeatures();
            for (Feature feature2 : inputFeatures) {
                result *= GeneralRegressionModelUtil.createPPCells(feature2, parameter, ppMatrix, covariates, factors);
            }
            return result;
        }
        if (feature instanceof PowerFeature) {
            PowerFeature powerFeature = (PowerFeature)feature;
            return GeneralRegressionModelUtil.createPPCell(String.valueOf(powerFeature.getPower()), powerFeature.getName(), parameter, ppMatrix, covariates);
        }
        ContinuousFeature continuousFeature = feature.toContinuousFeature();
        return GeneralRegressionModelUtil.createPPCell("1", continuousFeature.getName(), parameter, ppMatrix, covariates);
    }

    private static double createPPCell(Object value, FieldName name, Parameter parameter, PPMatrix ppMatrix, Set<FieldName> predictorNames) {
        PPCell ppCell = new PPCell(value, name, parameter.getName());
        ppMatrix.addPPCells(new PPCell[]{ppCell});
        predictorNames.add(ppCell.getField());
        return 1.0;
    }

    private static void createPredictors(PredictorList predictorList, Set<FieldName> names) {
        names = new LinkedHashSet<FieldName>(names);
        List predictors = predictorList.getPredictors();
        for (Predictor predictor : predictors) {
            names.remove(predictor.getField());
        }
        if (names.isEmpty()) {
            return;
        }
        for (FieldName name : names) {
            Predictor predictor = new Predictor(name);
            predictorList.addPredictors(new Predictor[]{predictor});
        }
    }
}

