/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter.visitors;

import java.util.List;
import java.util.ListIterator;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.dmg.pmml.Row;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.visitors.AbstractVisitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CellTransformer
extends AbstractVisitor {
    private Document document = null;

    public CellTransformer() {
        DocumentBuilder documentBuilder;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            throw new RuntimeException(pce);
        }
        this.document = documentBuilder.newDocument();
    }

    public VisitorAction visit(Row row) {
        if (row.hasContent()) {
            List content = row.getContent();
            this.transform(content);
        }
        return super.visit(row);
    }

    private void transform(List<Object> content) {
        ListIterator<Object> contentIt = content.listIterator();
        while (contentIt.hasNext()) {
            Object object = contentIt.next();
            if (!(object instanceof JAXBElement)) continue;
            JAXBElement jaxbElement = (JAXBElement)object;
            QName name = jaxbElement.getName();
            Element domElement = name.getPrefix().length() > 0 ? this.document.createElement(name.getPrefix() + ":" + name.getLocalPart()) : this.document.createElement(name.getLocalPart());
            domElement.setTextContent((String)jaxbElement.getValue());
            contentIt.set(domElement);
        }
    }
}

