/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.rexp;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.jpmml.rexp.RBooleanVector;
import org.jpmml.rexp.RDoubleVector;
import org.jpmml.rexp.RExp;
import org.jpmml.rexp.RIntegerVector;
import org.jpmml.rexp.RNumberVector;
import org.jpmml.rexp.RStringVector;
import org.jpmml.rexp.RVector;

public class RExpUtil {
    private static final Map<Class<?>, String> vectorTypes = new LinkedHashMap();

    private RExpUtil() {
    }

    public static DataType getDataType(String type) {
        switch (type) {
            case "character": 
            case "factor": {
                return DataType.STRING;
            }
            case "numeric": {
                return DataType.DOUBLE;
            }
            case "logical": {
                return DataType.BOOLEAN;
            }
        }
        throw new IllegalArgumentException(type);
    }

    public static String getVectorType(Class<?> clazz) {
        String vectorType = vectorTypes.get(clazz);
        if (vectorType == null) {
            if (RVector.class.isAssignableFrom(clazz)) {
                return "vector";
            }
            return "non-vector";
        }
        return vectorType;
    }

    public static RStringVector getClassNames(RExp rexp) {
        RStringVector result = rexp.getStringAttribute("class");
        return result;
    }

    public static boolean isFactor(RExp rexp) {
        if (rexp instanceof RIntegerVector) {
            RIntegerVector factor = (RIntegerVector)rexp;
            return factor.isFactor();
        }
        return false;
    }

    public static List<String> getFactorLevels(RIntegerVector factor) {
        if (!factor.isFactor()) {
            throw new IllegalArgumentException();
        }
        return factor.getLevelValues();
    }

    public static FieldName makeName(FieldName name) {
        return FieldName.create((String)RExpUtil.makeName(name.getValue()));
    }

    public static String makeName(String string) {
        StringBuilder sb = new StringBuilder();
        if (string.length() == 0) {
            sb.append('X');
        } else {
            char c = string.charAt(0);
            if (!Character.isLetter(c) && c != '.') {
                sb.append('X');
            }
        }
        for (int i = 0; i < string.length(); ++i) {
            int c = string.charAt(i);
            if (!(Character.isLetter((char)c) || c >= 48 && c <= 57 || c == 46 || c == 95)) {
                c = 46;
            }
            sb.append((char)c);
        }
        return sb.toString();
    }

    static {
        vectorTypes.put(RBooleanVector.class, "logical");
        vectorTypes.put(RDoubleVector.class, "numeric");
        vectorTypes.put(RIntegerVector.class, "integer");
        vectorTypes.put(RNumberVector.class, "numeric");
        vectorTypes.put(RStringVector.class, "character");
    }
}

