/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.rexp;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import java.util.List;
import org.dmg.pmml.DataType;
import org.jpmml.rexp.RNumberVector;
import org.jpmml.rexp.RPair;
import org.jpmml.rexp.RStringVector;

public class RIntegerVector
extends RNumberVector<Integer> {
    private int[] values = null;

    public RIntegerVector(int[] values, RPair attributes) {
        super(attributes);
        this.values = values;
    }

    @Override
    public DataType getDataType() {
        if (this.isFactor()) {
            return DataType.STRING;
        }
        return DataType.INTEGER;
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    public Integer getValue(int index) {
        int value = this.values[index];
        if (value == Integer.MIN_VALUE) {
            return null;
        }
        return value;
    }

    @Override
    public List<Integer> getValues() {
        Function<Integer, Integer> function = new Function<Integer, Integer>(){

            public Integer apply(Integer value) {
                if (value == Integer.MIN_VALUE) {
                    return null;
                }
                return value;
            }
        };
        return Lists.transform((List)Ints.asList((int[])this.values), (Function)function);
    }

    public boolean isFactor() {
        return this.hasAttribute("levels");
    }

    public RStringVector getLevels() {
        return this.getStringAttribute("levels");
    }

    public List<String> getLevelValues() {
        RStringVector levels = this.getLevels();
        return levels.getValues();
    }

    public String getFactorValue(int index) {
        RStringVector levels = this.getLevels();
        Integer value = this.getValue(index);
        if (value == null) {
            return null;
        }
        return levels.getValue(value - 1);
    }

    public List<String> getFactorValues() {
        List<Integer> values = this.getValues();
        final List<String> levelValues = this.getLevelValues();
        Function<Integer, String> function = new Function<Integer, String>(){

            public String apply(Integer value) {
                if (value == null) {
                    return null;
                }
                return (String)levelValues.get(value - 1);
            }
        };
        return Lists.transform(values, (Function)function);
    }
}

