/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml.regression;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.HasTargetFieldReference;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelExplanation;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.ModelVerification;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.StringValue;
import org.dmg.pmml.Targets;
import org.dmg.pmml.Version;
import org.dmg.pmml.Visitable;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.dmg.pmml.regression.HasRegressionTables;
import org.dmg.pmml.regression.PMMLAttributes;
import org.dmg.pmml.regression.PMMLElements;
import org.dmg.pmml.regression.RegressionTable;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Deprecated;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name="RegressionModel", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions", "miningSchema", "output", "modelStats", "modelExplanation", "targets", "localTransformations", "regressionTables", "modelVerification"})
@JsonRootName(value="RegressionModel")
@JsonPropertyOrder(value={"modelName", "miningFunction", "algorithmName", "modelType", "targetField", "normalizationMethod", "scorable", "mathContext", "extensions", "miningSchema", "output", "modelStats", "modelExplanation", "targets", "localTransformations", "regressionTables", "modelVerification"})
public class RegressionModel
extends Model
implements HasExtensions<RegressionModel>,
HasTargetFieldReference<RegressionModel>,
HasRegressionTables<RegressionModel> {
    @XmlAttribute(name="modelName")
    @JsonProperty(value="modelName")
    private String modelName;
    @XmlAttribute(name="functionName", required=true)
    @JsonProperty(value="functionName")
    private MiningFunction miningFunction;
    @XmlAttribute(name="algorithmName")
    @JsonProperty(value="algorithmName")
    private String algorithmName;
    @XmlAttribute(name="modelType")
    @Deprecated(value=Version.PMML_3_0)
    @JsonProperty(value="modelType")
    private ModelType modelType;
    @XmlAttribute(name="targetFieldName")
    @XmlJavaTypeAdapter(value=FieldNameAdapter.class)
    @Deprecated(value=Version.PMML_3_0)
    @JsonProperty(value="targetFieldName")
    private String targetField;
    @XmlAttribute(name="normalizationMethod")
    @JsonProperty(value="normalizationMethod")
    private NormalizationMethod normalizationMethod;
    @XmlAttribute(name="isScorable")
    @Added(value=Version.PMML_4_1)
    @JsonProperty(value="isScorable")
    private Boolean scorable;
    @XmlAttribute(name="x-mathContext")
    @Added(value=Version.XPMML)
    @JsonProperty(value="x-mathContext")
    private MathContext mathContext;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    private List<Extension> extensions;
    @XmlElement(name="MiningSchema", namespace="http://www.dmg.org/PMML-4_4", required=true)
    @JsonProperty(value="MiningSchema")
    private MiningSchema miningSchema;
    @XmlElement(name="Output", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Output")
    private Output output;
    @XmlElement(name="ModelStats", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="ModelStats")
    private ModelStats modelStats;
    @XmlElement(name="ModelExplanation", namespace="http://www.dmg.org/PMML-4_4")
    @Added(value=Version.PMML_4_0)
    @JsonProperty(value="ModelExplanation")
    private ModelExplanation modelExplanation;
    @XmlElement(name="Targets", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Targets")
    private Targets targets;
    @XmlElement(name="LocalTransformations", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="LocalTransformations")
    private LocalTransformations localTransformations;
    @XmlElement(name="RegressionTable", namespace="http://www.dmg.org/PMML-4_4", required=true)
    @JsonProperty(value="RegressionTable")
    private List<RegressionTable> regressionTables;
    @XmlElement(name="ModelVerification", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="ModelVerification")
    private ModelVerification modelVerification;
    private static final Boolean DEFAULT_SCORABLE = true;
    private static final long serialVersionUID = 67371270L;

    public RegressionModel() {
    }

    @ValueConstructor
    public RegressionModel(@Property(value="miningFunction") MiningFunction miningFunction, @Property(value="miningSchema") MiningSchema miningSchema, @Property(value="regressionTables") List<RegressionTable> regressionTables) {
        this.miningFunction = miningFunction;
        this.miningSchema = miningSchema;
        this.regressionTables = regressionTables;
    }

    @Override
    public String getModelName() {
        return this.modelName;
    }

    @Override
    public RegressionModel setModelName(@Property(value="modelName") String modelName) {
        this.modelName = modelName;
        return this;
    }

    @Override
    public MiningFunction requireMiningFunction() {
        if (this.miningFunction == null) {
            throw new MissingAttributeException(this, PMMLAttributes.REGRESSIONMODEL_MININGFUNCTION);
        }
        return this.miningFunction;
    }

    @Override
    public MiningFunction getMiningFunction() {
        return this.miningFunction;
    }

    @Override
    public RegressionModel setMiningFunction(@Property(value="miningFunction") MiningFunction miningFunction) {
        this.miningFunction = miningFunction;
        return this;
    }

    @Override
    public String getAlgorithmName() {
        return this.algorithmName;
    }

    @Override
    public RegressionModel setAlgorithmName(@Property(value="algorithmName") String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    public ModelType getModelType() {
        return this.modelType;
    }

    public RegressionModel setModelType(@Property(value="modelType") ModelType modelType) {
        this.modelType = modelType;
        return this;
    }

    @Override
    public String getTargetField() {
        return this.targetField;
    }

    @Override
    public RegressionModel setTargetField(@Property(value="targetField") String targetField) {
        this.targetField = targetField;
        return this;
    }

    @Override
    public NormalizationMethod getNormalizationMethod() {
        if (this.normalizationMethod == null) {
            return NormalizationMethod.NONE;
        }
        return this.normalizationMethod;
    }

    @Override
    public RegressionModel setNormalizationMethod(@Property(value="normalizationMethod") NormalizationMethod normalizationMethod) {
        this.normalizationMethod = normalizationMethod;
        return this;
    }

    @Override
    public boolean isScorable() {
        if (this.scorable == null) {
            return DEFAULT_SCORABLE;
        }
        return this.scorable;
    }

    @Override
    public RegressionModel setScorable(@Property(value="scorable") Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    @Override
    public MathContext getMathContext() {
        if (this.mathContext == null) {
            return MathContext.DOUBLE;
        }
        return this.mathContext;
    }

    @Override
    public RegressionModel setMathContext(@Property(value="mathContext") MathContext mathContext) {
        this.mathContext = mathContext;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public RegressionModel addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public MiningSchema requireMiningSchema() {
        if (this.miningSchema == null) {
            throw new MissingElementException(this, PMMLElements.REGRESSIONMODEL_MININGSCHEMA);
        }
        return this.miningSchema;
    }

    @Override
    public MiningSchema getMiningSchema() {
        return this.miningSchema;
    }

    @Override
    public RegressionModel setMiningSchema(@Property(value="miningSchema") MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    @Override
    public Output getOutput() {
        return this.output;
    }

    @Override
    public RegressionModel setOutput(@Property(value="output") Output output) {
        this.output = output;
        return this;
    }

    @Override
    public ModelStats getModelStats() {
        return this.modelStats;
    }

    @Override
    public RegressionModel setModelStats(@Property(value="modelStats") ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    @Override
    public ModelExplanation getModelExplanation() {
        return this.modelExplanation;
    }

    @Override
    public RegressionModel setModelExplanation(@Property(value="modelExplanation") ModelExplanation modelExplanation) {
        this.modelExplanation = modelExplanation;
        return this;
    }

    @Override
    public Targets getTargets() {
        return this.targets;
    }

    @Override
    public RegressionModel setTargets(@Property(value="targets") Targets targets) {
        this.targets = targets;
        return this;
    }

    @Override
    public LocalTransformations getLocalTransformations() {
        return this.localTransformations;
    }

    @Override
    public RegressionModel setLocalTransformations(@Property(value="localTransformations") LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    @Override
    public boolean hasRegressionTables() {
        return this.regressionTables != null && !this.regressionTables.isEmpty();
    }

    @Override
    public List<RegressionTable> requireRegressionTables() {
        if (this.regressionTables == null || this.regressionTables.isEmpty()) {
            throw new MissingElementException(this, PMMLElements.REGRESSIONMODEL_REGRESSIONTABLES);
        }
        return this.regressionTables;
    }

    @Override
    public List<RegressionTable> getRegressionTables() {
        if (this.regressionTables == null) {
            this.regressionTables = new ArrayList<RegressionTable>();
        }
        return this.regressionTables;
    }

    @Override
    public RegressionModel addRegressionTables(RegressionTable ... regressionTables) {
        this.getRegressionTables().addAll(Arrays.asList(regressionTables));
        return this;
    }

    @Override
    public ModelVerification getModelVerification() {
        return this.modelVerification;
    }

    @Override
    public RegressionModel setModelVerification(@Property(value="modelVerification") ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, this.getMiningSchema(), this.getOutput(), this.getModelStats(), this.getModelExplanation(), this.getTargets(), this.getLocalTransformations());
            }
            if (status == VisitorAction.CONTINUE && this.hasRegressionTables()) {
                status = PMMLObject.traverse(visitor, this.getRegressionTables());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, (Visitable)this.getModelVerification());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum NormalizationMethod implements StringValue<NormalizationMethod>
    {
        NONE("none"),
        SIMPLEMAX("simplemax"),
        SOFTMAX("softmax"),
        LOGIT("logit"),
        PROBIT("probit"),
        CLOGLOG("cloglog"),
        EXP("exp"),
        LOGLOG("loglog"),
        CAUCHIT("cauchit");

        private final String value;

        private NormalizationMethod(String v) {
            this.value = v;
        }

        @Override
        public String value() {
            return this.value;
        }

        public static NormalizationMethod fromValue(String v) {
            for (NormalizationMethod c : NormalizationMethod.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }

        public String toString() {
            return this.value();
        }
    }

    @XmlType(name="")
    @XmlEnum
    public static enum ModelType implements StringValue<ModelType>
    {
        LINEAR_REGRESSION("linearRegression"),
        STEPWISE_POLYNOMIAL_REGRESSION("stepwisePolynomialRegression"),
        LOGISTIC_REGRESSION("logisticRegression");

        private final String value;

        private ModelType(String v) {
            this.value = v;
        }

        @Override
        public String value() {
            return this.value;
        }

        public static ModelType fromValue(String v) {
            for (ModelType c : ModelType.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }

        public String toString() {
            return this.value();
        }
    }
}

