% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate.R
\name{validate_endpoints}
\alias{validate_endpoints}
\title{Validate endpoints}
\usage{
validate_endpoints(
  idx = NULL,
  checks = c("discovery", "services", "requests"),
  methods = c("formal", "down", "valid")
)
}
\arguments{
\item{idx}{\code{[integer]}

Index numbers of endpoints to check. Index numbers follow
row numbers in \code{\link{o311_endpoints}}.}

\item{checks}{\code{[character]}

Which open311 method to check. By default, checks all
methods.}

\item{methods}{\code{[character]}

Which checks to apply. \code{formal} checks whether an
endpoint is uniquely identifiable through given names and jurisdictions
in \code{\link{o311_endpoints}}. \code{down} checks whether an endpoint
is reachable and ready for requests. \code{valid} checks whether a method
returns a valid output, i.e. a list or dataframe with more than 0
rows/elements. By default, applies all methods.}
}
\value{
A dataframe containing the name of the endpoint, one to three
columns on check results, and one to three columns on reasons if a check
turned out to be negative.
}
\description{
Checks whether and which endpoints are correctly defined, reachable,
and/or valid. Iterates through all endpoints defined in
\code{\link{o311_endpoints}} and returns their status along with a
reason, if applicable.
}
\examples{
\donttest{
# check the first three endpoints in o311_endpoints()
validate_endpoints(1:3)

# check only requests
validate_endpoints(1:3, checks = "requests")

# check only whether an endpoint is down
validate_endpoints(1:3, methods = "down")
}
}
