% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoints.R
\name{o311_add_endpoint}
\alias{o311_add_endpoint}
\alias{o311_reset_endpoints}
\alias{o311_endpoints}
\title{Endpoints}
\usage{
o311_add_endpoint(
  name,
  root,
  jurisdiction = NULL,
  key = FALSE,
  pagination = FALSE,
  limit = NULL,
  json = TRUE,
  dialect = NULL
)

o311_reset_endpoints()

o311_endpoints(...)
}
\arguments{
\item{name}{\code{[character]}

Name of an endpoint / city. This name can be arbitrary and only serves
for identification in \code{[o311_api]}.}

\item{root}{\code{[character]}

Base URL of the endpoint for sending production-grade requests. The root
URL commonly points to \code{"georeport/v2/"}.}

\item{jurisdiction}{\code{[character]}

Unique identifier of the jurisdiction. The jurisdiction is typically
defined as the domain of the respective city website. It is optional as
most endpoints only serve one jurisdiction.}

\item{key}{\code{[logical]}

Is an API key mandatory?}

\item{pagination}{\code{[logical]}

Are \code{requests} responses paginated?}

\item{limit}{\code{[integer]}

If paginated, how many requests does one page contain?}

\item{json}{\code{[logical]}

Are JSON responses supported? If \code{FALSE}, defaults to \code{"XML"}
responses. See also \code{\link{o311_api}}.}

\item{dialect}{\code{[character]}

open311 extension that the endpoint is built on. Common dialects include
CitySDK, Connected Bits, SeeClickFix and Mark-a-Spot. Currently, this
argument does nothing, but it could be used in the future to adjust
response handling based on dialect.}

\item{...}{List of key-value pairs where each pair is a filter.
The key represents the column and the value the requested column value.
All keys must be present in the column names of \code{o311_endpoints()}.}
}
\value{
For \code{o311_endpoints}, a dataframe containing all relevant
information on an endpoint. For \code{o311_add_endpoint}, the new endpoint,
invisibly. \code{o311_reset_endpoints} returns \code{NULL} invisibly.
If the new endpoint is a duplicate, \code{NULL} is returned invisibly.
}
\description{
Modify and examine defined open311 endpoints. \code{o311_endpoints()}
retrieves a list of endpoints including additional information.
\code{o311_add_endpoint} adds to this list to define a new endpoint that
can be used for queries. \code{o311_reset_endpoints} restores the initial
state of the endpoints list.
}
\details{
\code{o311_endpoints()} returns a static list defined in the package
installation directory. This list contains a limited number of endpoints
that were proven to work at the time of package development. It does not
include newer/smaller/less known endpoints or test APIs. These can be
manually added using \code{o311_add_endpoint}.
}
\note{
This function uses \code{\link[tools]{R_user_dir}} to persistently store
custom endpoints data between sessions. To set a different directory, you
may use \code{options("o311_user_dir")}. To clean up, run
\code{o311_reset_endpoints()} which deletes the package-specific user
directory and defaults back to
\code{system.file("endpoints.json", package = "r311")}.
}
\examples{
# read default endpoints
o311_endpoints()

# get all endpoints powered by Connected Bits
o311_endpoints(dialect = "Connected Bits")

# add a new endpoint
o311_add_endpoint(name = "test", root = "test.org/georeport/v2")

# read new endpoints
o311_endpoints()

# reset endpoints back to default
o311_reset_endpoints()
}
\seealso{
\code{\link{o311_api}}
}
