% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSplotSPR.R
\name{SSplotSPR}
\alias{SSplotSPR}
\title{Plot SPR quantities.}
\usage{
SSplotSPR(replist, add = FALSE, plot = TRUE, print = FALSE,
  uncertainty = TRUE, subplots = 1:4, forecastplot = FALSE,
  col1 = "black", col2 = "blue", col3 = "green3", col4 = "red",
  sprtarg = "default", btarg = "default", labels = c("Year", "SPR",
  "1-SPR"), pwidth = 6.5, pheight = 5, punits = "in", res = 300,
  ptsize = 10, cex.main = 1, plotdir = "default", verbose = TRUE)
}
\arguments{
\item{replist}{list created by \code{SSoutput}}

\item{add}{add to existing plot (not yet implemented)}

\item{plot}{plot to active plot device?}

\item{print}{print to PNG files?}

\item{uncertainty}{include plots showing uncertainty?}

\item{subplots}{vector controlling which subplots to create}

\item{forecastplot}{Include forecast years in plot?}

\item{col1}{first color used}

\item{col2}{second color used}

\item{col3}{third color used}

\item{col4}{fourth color used}

\item{sprtarg}{F/SPR proxy target. "default" chooses based on model output.}

\item{btarg}{target depletion to be used in plots showing depletion. May be
omitted by setting to NA. "default" chooses based on model output.}

\item{labels}{vector of labels for plots (titles and axis labels)}

\item{pwidth}{width of plot}

\item{pheight}{height of plot}

\item{punits}{units for PNG file}

\item{res}{resolution for PNG file}

\item{ptsize}{point size for PNG file}

\item{cex.main}{character expansion for plot titles}

\item{plotdir}{directory where PNG files will be written. by default it will
be the directory where the model was run.}

\item{verbose}{report progress to R GUI?}
}
\description{
Plot SPR quantities, including 1-SPR and phase plot.
}
\seealso{
\code{\link{SS_plots}}, \code{\link{SS_output}}
}
\author{
Ian Stewart, Ian Taylor
}
