% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_r5.R
\name{download_r5}
\alias{download_r5}
\title{Download R5 Jar file}
\usage{
download_r5(
  version = "6.0.1",
  quiet = FALSE,
  force_update = FALSE,
  temp_dir = FALSE
)
}
\arguments{
\item{version}{character string with the version of R5 to be downloaded.
Defaults to latest version '1.0'.}

\item{quiet}{logical, passed to download.file. Defaults to FALSE}

\item{force_update}{logical, Replaces the jar file stored locally with a new
one. Defaults to FALSE.}

\item{temp_dir}{logical, whether the R5 Jar file should be saved in temporary
directory. Defaults to FALSE}
}
\value{
A jar file is saved locally in the r5r package directory
}
\description{
Download a compiled JAR file of R5 and saves it locally.
The JAR file is saved within the package directory. The package uses a
compilation of R5 tailored for the purposes of r5r that keeps R5's
essential features. Source code available at https://github.com/ipeaGIT/r5r.
}
\examples{
\dontrun{

library(r5r)

download_r5(version = "6.0.1", temp_dir = TRUE)
}
}
\seealso{
Other setup: 
\code{\link{setup_r5}()}
}
\concept{setup}
