% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chart_amRadar.R
\name{amRadar}
\alias{amRadar}
\title{Plotting radar}
\usage{
amRadar(
  data,
  col = NULL,
  backTransparency = 0.5,
  type = "polygons",
  pch = "round",
  xlim = NULL,
  ...
)
}
\arguments{
\item{data}{\code{data.frame} first column is named "label" (character), other columns are series of values,
see \link{data_radar}.}

\item{col}{\code{character}, color(s) of serie(s) hexadecimal like "#00FF00".}

\item{backTransparency}{\code{numeric}, background transparency, between 0 and 1.}

\item{type}{\code{character}, type of radar. Possible values are : "polygons" or "circle".}

\item{pch}{\code{character}, points symbols. Possible values are : "round", "square", "triangleUp", 
"triangleDown", "triangleLeft", "triangleRight", "bubble", 
"diamond", "xError", "yError".}

\item{xlim}{\code{numeric}, x range.}

\item{...}{see \code{\link{amOptions}} for more options.}
}
\description{
radar computes a radarplot of the given data values.
}
\examples{

\dontrun{
 
data("data_radar")
amRadar(data_radar)

# Other examples available which can be time consuming depending on your configuration.

if (requireNamespace("pipeR", quietly = TRUE)) {
require(pipeR)

# Change color
amRadar(data_radar, col = "#FF0000")
amRadar(data_radar, col = c("#0000FF", "#00FF00", "#FF0000"))


# Change backTransparency
amRadar(data_radar, backTransparency = 0.6)
amRadar(data_radar, backTransparency = c(0, 0.4, 0.6))


# Change type
amRadar(data_radar, type = "circles")

# Change pch
amRadar(data_radar,  pch = "triangleRight")
amRadar(data_radar,  pch = "triangleLeft")

# Min-Max
amRadar(data_radar, xlim = c(0, 8))
}
}


}
\references{
See online documentation \url{https://datastorm-open.github.io/introduction_ramcharts/}
and \link{amChartsAPI}
}
\seealso{
\link{amOptions}, \link{amBarplot}, \link{amBoxplot}, \link{amHist}, \link{amPie},
\link{amPlot}, \link{amTimeSeries}, \link{amStockMultiSet}, \link{amBullet}, \link{amRadar}, 
\link{amWind}, \link{amFunnel}, \link{amAngularGauge}, \link{amSolidGauge}, \link{amMekko},
\link{amCandlestick}, \link{amFloatingBar}, \link{amOHLC}, \link{amWaterfall}
}
