% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amGaugeChart.R
\name{amGaugeChart}
\alias{amGaugeChart}
\title{HTML widget displaying a gauge chart}
\usage{
amGaugeChart(
  score,
  minScore,
  maxScore,
  scorePrecision = 0,
  gradingData,
  innerRadius = 70,
  labelsRadius = (100 - innerRadius)/2,
  axisLabelsRadius = 19,
  chartFontSize = 11,
  labelsFont = amFont(fontSize = "2em", fontWeight = "bold"),
  axisLabelsFont = amFont(fontSize = "1.2em"),
  scoreFont = amFont(fontSize = "6em"),
  scoreLabelFont = amFont(fontSize = "2em"),
  hand = amHand(innerRadius = 45, width = 8, color = "slategray", strokeColor =
    "black"),
  gridLines = FALSE,
  chartTitle = NULL,
  theme = NULL,
  backgroundColor = NULL,
  caption = NULL,
  image = NULL,
  width = NULL,
  height = NULL,
  export = FALSE,
  chartId = NULL,
  elementId = NULL
)
}
\arguments{
\item{score}{gauge value, a number between \code{minScore} and
\code{maxScore}}

\item{minScore}{minimal score}

\item{maxScore}{maximal score}

\item{scorePrecision}{an integer, the number of decimals of the score
to be displayed}

\item{gradingData}{data for the gauge, a dataframe with three required
columns: \code{label}, \code{lowScore}, and \code{highScore}, and an
optional column \code{color}; if the column \code{color} is not present,
then the colors will be derived from the theme}

\item{innerRadius}{inner radius of the gauge given as a percentage,
between \code{0} (the gauge has no width) and \code{100} (the gauge is
a semi-disk)}

\item{labelsRadius}{radius for the labels given as a percentage; use the
default value to get centered labels}

\item{axisLabelsRadius}{radius for the axis labels given as a percentage}

\item{chartFontSize}{reference font size, a numeric value, the font size in
pixels; this font size has an effect only if you use the relative CSS unit
\code{em} for other font sizes}

\item{labelsFont}{a list of settings for the font of the labels created with
\code{\link{amFont}}, but the font size must be given in pixels or in
\code{em} CSS units (no other units are accepted)}

\item{axisLabelsFont}{a list of settings for the font of the axis labels
created with \code{\link{amFont}}}

\item{scoreFont}{a list of settings for the font of the score created with
\code{\link{amFont}}}

\item{scoreLabelFont}{a list of settings for the font of the score label
created with \code{\link{amFont}}}

\item{hand}{a list of settings for the hand of the gauge created with
\code{\link{amHand}}}

\item{gridLines}{a list of settings for the grid lines created with
\code{\link{amLine}}, or a logical value: \code{FALSE} for no grid lines,
\code{TRUE} for default grid lines}

\item{chartTitle}{chart title, it can be \code{NULL} or \code{FALSE} for no
title, a character string,
a list of settings created with \code{\link{amText}}, or a list with two
fields: \code{text}, a list of settings created with \code{\link{amText}},
and \code{align}, can be \code{"left"}, \code{"right"} or \code{"center"}}

\item{theme}{theme, \code{NULL} or one of \code{"dataviz"},
\code{"material"}, \code{"kelly"}, \code{"dark"}, \code{"moonrisekingdom"},
\code{"frozen"}, \code{"spiritedaway"}, \code{"patterns"},
\code{"microchart"}}

\item{backgroundColor}{a color for the chart background; it can be given by
the name of a R color, the name of a CSS
color, e.g. \code{"aqua"} or \code{"indigo"}, an HEX code like
\code{"#ff009a"}, a RGB code like \code{"rgb(255,100,39)"}, or a HSL code
like \code{"hsl(360,11,255)"}}

\item{caption}{\code{NULL} or \code{FALSE} for no caption, a formatted
text created with \code{\link{amText}}, or a list with two fields:
\code{text}, a list created with \code{\link{amText}}, and \code{align},
can be \code{"left"}, \code{"right"} or \code{"center"}}

\item{image}{option to include an image at a corner of the chart;
\code{NULL} or \code{FALSE} for no image, otherwise a named list with four
possible fields: the field \code{image} (required) is a list created with
\code{\link{amImage}},
the field \code{position} can be \code{"topleft"}, \code{"topright"},
\code{"bottomleft"} or \code{"bottomright"}, the field \code{hjust}
defines the horizontal adjustment, and the field \code{vjust} defines
the vertical adjustment}

\item{width}{the width of the chart, e.g. \code{"600px"} or \code{"80\%"};
ignored if the chart is displayed in Shiny, in which case the width is
given in \code{\link{amChart4Output}}}

\item{height}{the height of the chart, e.g. \code{"400px"};
ignored if the chart is displayed in Shiny, in which case the height is
given in \code{\link{amChart4Output}}}

\item{export}{logical, whether to enable the export menu}

\item{chartId}{a HTML id for the chart}

\item{elementId}{a HTML id for the container of the chart; ignored if the
chart is displayed in Shiny, in which case the id is given by the Shiny id}
}
\description{
Create a HTML widget displaying a gauge chart.
}
\note{
In Shiny, you can change the score of a gauge chart with the help of
  \code{\link{updateAmGaugeChart}}.
}
\examples{
library(rAmCharts4)

gradingData <- data.frame(
  label = c("Slow", "Moderate", "Fast"),
  color = c("blue", "green", "red"),
  lowScore = c(0, 100/3, 200/3),
  highScore = c(100/3, 200/3, 100)
)

amGaugeChart(
  score = 40, minScore = 0, maxScore = 100, gradingData = gradingData
)
}
