% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification.R
\name{classification}
\alias{classification}
\title{A classification function}
\usage{
classification(test, rules, verbose = TRUE)
}
\arguments{
\item{test}{\code{data.frame} or \code{transactions} from \code{arules} with input data}

\item{rules}{\code{data.frame} with rules}

\item{verbose}{verbose indicator}
}
\value{
vector with classifications
}
\description{
A classification function
}
\examples{
library("arules")
library("rCBA")
data("iris")

train <- sapply(iris, as.factor)
train <- data.frame(train, check.names=FALSE)
txns <- as(train,"transactions")

rules = apriori(txns, parameter=list(support=0.03, confidence=0.03, minlen=2),
appearance = list(rhs=c("Species=setosa", "Species=versicolor", "Species=virginica"),default="lhs"))

predictions <- rCBA::classification(train,rules)
table(predictions)
sum(as.character(train$Species)==as.character(predictions),na.rm=TRUE)/length(predictions)
}
