% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pruning.R
\name{pruning}
\alias{pruning}
\title{A Pruning function}
\usage{
pruning(train, rules, method = "m2cba", verbose = TRUE, parallel = TRUE)
}
\arguments{
\item{train}{trainData \code{data.frame} or \code{transactions} from \code{arules} with input data}

\item{rules}{\code{data.frame} with rules}

\item{method}{pruning method m2cba(default)|m1cba|dcbrcba}

\item{verbose}{verbose indicator}

\item{parallel}{parallel indicator}
}
\value{
\code{data.frame} with pruned rules
}
\description{
A Pruning function
}
\examples{
library("arules")
library("rCBA")
data("iris")

train <- sapply(iris,as.factor)
train <- data.frame(train, check.names=FALSE)
txns <- as(train,"transactions")

rules = apriori(txns, parameter=list(support=0.03, confidence=0.03, minlen=2),
appearance = list(rhs=c("Species=setosa", "Species=versicolor", "Species=virginica"),default="lhs"))

print(length(rules))
prunedRules <- rCBA::pruning(train, rules, method="m2cba", parallel=FALSE)
print(length(prunedRules))
}
