% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportVCF.R
\name{exportVCF}
\alias{exportVCF}
\title{Export VCF files}
\usage{
exportVCF(out.vcf, out.path, compress = TRUE)
}
\arguments{
\item{out.vcf}{a matrix or data frame in vcf file format to be exported}

\item{out.path}{a character string of output path for the vcf file;
should end in the name as the vcf file and .vcf. See examples}

\item{compress}{logical. whether to compress the output file. If \code{TRUE},
the file will be \code{.gz} compressed}
}
\value{
Exports a vcf file to a given destination
}
\description{
A function to export tables/matrices in VCF format to VCF files
}
\examples{
\dontrun{vcf.file.path <- paste0(path.package("rCNV"), "/example.raw.vcf.gz")
vcf <- readVCF(vcf.file.path)
exportVCF(vcf,"../exVcf.vcf")}

}
\author{
Piyal Karunarathne
}
