\name{mtq}
\alias{mtq}
\docType{data}
\title{
Census Data on Communes of the Martinique Island
}
\description{
Some demographic variables from censuses (1999 and 2009).
}
\usage{data(mtq)}
\format{
  A data frame with 34 observations on the following 16 variables.
  \describe{
    \item{\code{ID}}{a numeric vector, INSEE Ids of the communes}
    \item{\code{P09_POP}}{total population in 2009}
    \item{\code{P99_POP}}{total population in 1999}
    \item{\code{P09_POP0014}}{population of 00-14 years population in 2009}
    \item{\code{P09_POP1529}}{population of 15-29 years population in 2009}
    \item{\code{P09_POP3044}}{population of 30-44 years population in 2009}
    \item{\code{P09_POP4559}}{population of 45-59 years population in 2009}
    \item{\code{P09_POP6074}}{population of 60-74 years population in 2009}
    \item{\code{P09_POP75P}}{population of 75 and more years population in 2009}
    \item{\code{P99_POP0014}}{population of 00-14 years population in 2009}
    \item{\code{P99_POP1529}}{population of 15-29 years population in 2009}
    \item{\code{P99_POP3044}}{population of 30-44 years population in 2009}
    \item{\code{P99_POP4559}}{population of 45-59 years population in 2009}
    \item{\code{P99_POP6074}}{population of 60-74 years population in 2009}
    \item{\code{P99_POP75P}}{population of 75 and more years population in 2009}
  }
}
\source{
Chiffres cles - Evolution et structure de la population 

Decoupage geographique au 01/01/2011 - Mise en ligne le 28 juin 2012 

Insee, Recensements de la population - Etat civil.

Original data can be retreived here (page reached on 2012-11-16):\cr
http://www.recensement.insee.fr/telechargement/bases-chiffres-cles/BTX_CC_POP_2009.zip


}
\seealso{
  \tabular{ll}{
  \link[=rCarto-package]{rCarto-package} \tab rCarto package \cr
  \link[=mapCircles]{mapCircles} \tab proportional circles \cr
  \link[=mapCirclesChoro]{mapCirclesChoro} \tab proportional circles colored by a discretized quantitative variable\cr
  \link[=mapCirclesTypo]{mapCirclesTypo} \tab proportional circles colored by the modalities of a qualitative variable\cr
  \link[=mapChoropleth]{mapChoropleth} \tab choropleth \cr
  \link[=mapChoroTypo]{mapChoroTypo} \tab typology \cr
  \link[=mtq]{mtq} \tab data \cr
  \link[=commune]{commune} \tab shapefile \cr
  }
}
\examples{
data(mtq)
}
