% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qedata_define.R
\name{codes}
\alias{codes}
\title{Reclassify specified columns as codes or list codes columns in a data.table}
\usage{
codes(x, ...)
}
\arguments{
\item{x}{A data.table. The data.table containing the columns to be reclassified or checked.}

\item{...}{Additional arguments specifying the names of the columns to be reclassified.}
}
\value{
The modified data.table with specified columns reclassified as 'qe.code', or a character vector of column names already classified as 'qe.unit'.
}
\description{
This function reclassifies specified columns of a data.table to the 'qe.code' format if column names are provided.
If no column names are provided, it returns the names of columns that are already classified as 'qe.code'.
}
\examples{
library(data.table)
dt <- data.table(a = 1:5, b = 6:10)
# Reclassify columns 'a' and 'b' as 'qe.code'
dt <- codes(dt, "a", "b")
# List columns classified as 'qe.code'
code_columns <- codes(dt)
}
