% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rMEA_class.R
\name{MEA}
\alias{MEA}
\alias{is.MEA}
\title{\code{MEA} class constructor}
\usage{
MEA(dataframe, sampRate, filter = "raw", id, session, group, s1Name,
  s2Name, uid = paste(group, id, session, sep = "_"))

is.MEA(x)
}
\arguments{
\item{dataframe}{a data frame with 2 columns containing MEA data respectively for subject 1 (s1) and subject 2 (s2).}

\item{sampRate}{integer. The sampling rate of the MEA data. Normally derived from the framerate of the analyzed video sequence (frames per second; fps).}

\item{filter}{a string describing the pre-processing that has been applied on the raw data.}

\item{id}{a string representing a unique identifier of the dyad that the MEA data belong to.}

\item{session}{an integer representing the session (or experiment, interaction, etc); if each dyad is measured only once, the default value is 1.}

\item{group}{a string naming the group the dyad belongs to, such as diagnostic group, clinic, etc.}

\item{s1Name}{a string naming subject 1.}

\item{s2Name}{a string naming subject 2.}

\item{uid}{a string providing a unique identifier of the file. By default 'group_id_session'.}

\item{x}{object to be tested.}
}
\value{
A list containing three objects:

    MEA: the dataframe containing the motion energy data

    ccf: the matrix of lagged cross-correlations between s1 and s2 (if \code{\link[rMEA]{MEAccf}} was run)

    ccfRes: some useful row marginals

\code{is.MEA} returns TRUE if and only if its argument is of class \code{MEA}
}
\description{
The preferred way to create an object of class \code{MEA} is through the function \code{\link{readMEA}}.
}
\details{
It is advised to \strong{not} create the \code{MEA} object manually but to always use the function \code{\link{readMEA}} instead.
}
