% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rMea_filter.R
\name{MEAmap}
\alias{MEAmap}
\title{Apply a function to a single or a list of MEA objects}
\usage{
MEAmap(mea, FUN, label = "", ...)
}
\arguments{
\item{mea}{an object of class \code{MEA} or a list of \code{MEA} objects (see function \code{\link{readMEA}})}

\item{FUN}{function to apply, found via \code{\link[base]{match.fun}}.}

\item{label}{a character vector to update the 'filter' attribute of \code{mea}.}

\item{...}{further arguments passed to \code{FUN}. If a function is provided,
it will be run on each MEA object and then passed as an argument to \code{FUN}.}
}
\value{
an object of the same class of the provided \code{'mea'} object, with the transformed motion energy data
}
\description{
MEApply is a wrapper to \code{\link[base]{do.call}} that allows to apply a function on the motion energy data of one or multiple \code{MEA} objects. Complex constructions are possible, see details.
}
\details{
\code{FUN} will be applied on the motion energy time-series of \code{MEA} objects, which is stored as a data frame with 2 columns, respectively for s1 and s2.
}
