% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MVP.Report.r
\name{MVP.Report.QQplot}
\alias{MVP.Report.QQplot}
\title{QQ Plot}
\usage{
MVP.Report.QQplot(
  P.values,
  taxa_name,
  col = c("blue"),
  cex = 0.5,
  threshold = NULL,
  amplify = TRUE,
  signal.col = "red",
  signal.pch = 19,
  signal.cex = 0.8,
  conf.int = TRUE,
  cex.axis = 1,
  conf.int.col = "grey",
  threshold.col = "red",
  outpath = getwd(),
  file.type = "jpg",
  memo = "MVP",
  box = TRUE,
  dpi = 300,
  file.output = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{P.values}{P values}

\item{taxa_name}{The identifier of the phenotype will be used to generate a
portion of the image file name. If the title parameter is NULL, it will 
also be part of the title.}

\item{col}{default color is "blue"}

\item{cex}{A numerical value giving the amount by which plotting text and
symbols should be magnified relative to the default. This starts as 1 
when a device is opened, and is reset when the layout is changed, e.g. 
by setting mfrow. see \code{\link[graphics]{par}}.}

\item{threshold}{Number or Vector. The cutoff line on Manhattan plot, 
e.g. Bonfferoni correction. More than one significant line can be added
onto one figure. If threshold=0 or NULL, the threshold line will not be
added.}

\item{amplify}{Logical value. If TRUE, the points that passed the threshold line will be highlighted}

\item{signal.col}{Character. If "amplify" is TRUE, "signal.col" is used to set the color of significant points, if "signal.col" is NULL, the colors of significant points will not be changed}

\item{signal.pch}{Number. If "amplify" is TRUE, users can set the type of significant points}

\item{signal.cex}{Number. If "amplify" is TRUE, "signal.cex" is used to set the size of significant points}

\item{conf.int}{Whether to draw a confidence interval}

\item{cex.axis}{a number, controls the size of numbers of X-axis and the size of labels of circle plot.}

\item{conf.int.col}{a character, the color of the confidence interval on QQ-plot.}

\item{threshold.col}{Character or Vector. The colors of threshold lines}

\item{outpath}{Only when file.output = TRUE, determines the path of the output file}

\item{file.type}{A string or NULL is used to determine the type of output 
file. Can be "jpg", "pdf", "tiff". If it is NULL, it will use 
\code{\link[grDevices:dev]{dev.new()}} to create a new graphics device 
in the current environment, which may be RStudioGD or the default 
device of the system.}

\item{memo}{the prefix of the output image file.}

\item{box}{A Boolean value that controls whether to draw a box around
QQplot.}

\item{dpi}{a number, the picture element for .jpg and .tiff files. The default is 300.}

\item{file.output}{Logical value. If TRUE, the figures will be generated.}

\item{verbose}{whether to print detail.}
}
\value{
Output file:
<memo>.QQplot.<taxa_name>.<type>
}
\description{
QQ Plot
}
\examples{
data(pig60K, package = "rMVP")

MVP.Report(pig60K[1:10000,], plot.type="q", file.output=FALSE)

}
