% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rPACI.R
\name{plotSingleCornea}
\alias{plotSingleCornea}
\title{Summary plot of the Placido irregularity indices}
\usage{
plotSingleCornea(dataset, PlacidoIndices, filename = NULL)
}
\arguments{
\item{dataset}{A dataset containing the read corneal topography.}

\item{PlacidoIndices}{A dataset of results as given by the function \link[rPACI]{computePlacidoIndices} or \link[rPACI]{analyzeFile}.}

\item{filename}{An optional character argument, corresponding to the file containing the analyzed data.
If specified, the filename is displayed on the plot.}
}
\description{
Draw a three-part plot summarizing the corneal topography analysis, based on the Placido irregularity indices calculated by the function \link[rPACI]{computePlacidoIndices}.
}
\examples{
dataset = readCornealTopography(system.file("extdata","K04.txt", package="rPACI"))
results = computePlacidoIndices(dataset)
plotSingleCornea(dataset, results)
}
