\name{rPowerSampleSize-package}
\alias{rPowerSampleSize-package}
\alias{rPowerSampleSize}
\docType{package}
\title{Sample Size Computation and Data Analysis in the context of multiple continuous endpoints in clinical trials.
}
\description{
The package rPowerSampleSize has been developped in order to compute the sample size, and to analyse the data, in the context of multiple primary continuous endpoints 
in clinical trials. Two approaches are available for the decision rule ``at least one significant endpoint among m''. All the procedures which correspond to
this decision rule include 1m in the name of the function. An individual procedure based on Union-Intersection Procedure, and a global method based on multivariate 
linear model. This package for this decision rule contains four functions: two for the sample size determination (one for individual procedure, and one for a global 
method), and two for data analysis in order to resolve the multiple testing problems (one for individual procedure, and one for a global method). The sample size 
computation for the Bonferroni Procedure is also available. A generalisation of the first case is also available with a decision rule ``at least r significant endpoint
among the m primary endpoint''. The procedure which corresponds to this decision rule include rm in the name of the function. We have one functions here where we study 
the sample size computation.
}
\details{
\tabular{ll}{
Package: \tab rPowerSampleSize\cr
Type: \tab Package\cr
Version: \tab 1.0\cr
Date: \tab 2012-03-21\cr
License: \tab GPL (>2) \cr
LazyLoad: \tab yes\cr
}
}

\author{
Pierre Lafaye de Micheaux, Benoit Liquet and Jeremie Riou
Maintainer: Pierre Lafaye de Micheaux <lafaye@dms.umontreal.ca> 
}

\keyword{package}
\keyword{multivariate models}
\keyword{multiple testing}
\keyword{data analysis}
\keyword{sample size computation}
\keyword{individual procedure}

