% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sourceSHAPE.R
\name{createGenotypes}
\alias{createGenotypes}
\title{This function searches the nearby mutational space of a focal genotype, identifies which genotypes in that space have not
yet been identified, and create new database entries for any new genotypes.}
\usage{
createGenotypes(tmp_focalGenotype, tmp_focalFitness, maxHamming,
  tmp_landModel = "HoC", tmp_sepString = getOption("shape_sepString"),
  tmpDirection = getOption("shape_allow_backMutations"),
  tmp_relativeFitness = getOption("shape_const_relativeFitness"),
  tmp_currNeighbours = NULL, tmp_genCon,
  tmp_tableSplit = getOption("shape_db_splitTables"),
  tmp_maxRows = getOption("shape_maxRows"),
  tmp_genomeLength = getOption("shape_genomeLength"),
  tmp_distAsS = getOption("shape_const_distAsS"), ...)
}
\arguments{
\item{tmp_focalGenotype}{This is the focal genotype for which we want to create missing mutational neighbours.}

\item{tmp_focalFitness}{This is the fitness value of the tmp_focalGenotype.}

\item{maxHamming}{The maximum number of sites that could be changed by mutation of the tmp_focalGenotype.
NOTE: At present I've not made the code work for anything other than a value of 1.  So do not update
without updating associated code. where appropriate.}

\item{tmp_landModel}{This is the character string that defines the fitness landscape model being simulated in this SHAPE run.
At present it can be one of: \strong{Additive, Fixed, HoC, NK, RMF}}

\item{tmp_sepString}{This is a character string used to collapse vectors of characters.}

\item{tmpDirection}{This is a logical which controls if reversions are allowed (ie: if TRUE sites can revert from mutated to WT)}

\item{tmp_relativeFitness}{This is a logical which controls if fitness values are to be calculated as relative and no absolute values
that would otherwise be calculated via calls to the fitness landscape model.}

\item{tmp_currNeighbours}{This is an optinal vector that would define the genotype of all neighbours within the 1 step mutational
neighbourhood of the tmp_focalGenotype genotype.  If NULL then this vector will be calculated within the function.}

\item{tmp_genCon}{This is the filepath for the database file that contains the fitness landscape information.}

\item{tmp_tableSplit}{This is a logical which controls if the tables which report on all genotypes with X mutations should be
forced into a single table or it SHAPE is allowed to split them into multiple tables.}

\item{tmp_maxRows}{The maximum number of rows allowed in a database table before a new table is created.  This has no meaning
if tmp_tableSplit is FALSE.}

\item{tmp_genomeLength}{The length of the genomes, or number of mutable sites/positions, being simulated.}

\item{tmp_distAsS}{This arugment is passed through to downstream function, but will control if the stochastic portion of
fitness effect will be considered as selection coefficients (meaning subtracting 1 from the initially drawn value).}

\item{...}{Additional arguments that may get passed to internal functions.}
}
\value{
This invisibly returns NULL, this function is to perform work on databases.
}
\description{
This function searches the nearby mutational space of a focal genotype, identifies which genotypes in that space have not
yet been identified, and create new database entries for any new genotypes.
}
\section{Note}{

There is no example as this cannot work outisde of a runSHAPE call, it requires data produced by the simulation experiment.
}

