\name{tDWT}
\alias{tDWT}
\title{Discrete Wavelet Transform of a 3-D Tensor}

\description{
Performs the Discrete Wavelet Transform of a 3-D Tensor.
}
\usage{
tDWT(tnsr)
}
\arguments{
\item{tnsr}{: a 3-mode tensor}
}
\value{
a \href{/library/rTensor/help/Tensor-class}{Tensor-class} object
}
\author{
Kyle Caudle kyle.caudle@sdsmt.edu
}
\references{
G. Strang and T. Nguyen, Wavelets and filter banks. SIAM, 1996.

A. Haar, "Zur theorie der orthogonalen funktionensysteme", Mathematische annalen, vol. 69, no. 3, pp. 331-371, 1910.
}
\examples{
require(rTensor)
T <- rand_tensor(modes=c(2,3,4))
print(tDWT(T))
}
