% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_stand.R
\name{plot_stand}
\alias{plot_stand}
\title{Plot Stand}
\usage{
plot_stand(
  qsms,
  radius_type = "modified",
  qsm_colors = NULL,
  cyl_sides = 8,
  clouds = NULL,
  pt_colors = NULL,
  pt_sizes = NULL,
  axes = TRUE
)
}
\arguments{
\item{qsms}{A list of QSM cylinder data frames.}

\item{radius_type}{Radius type as either "modified", "unmodified", or "old". Defaults to "modified".}

\item{qsm_colors}{Optional qsm color parameters. Colors vector of hex colors with the same length as the qsms list. Defaults to distinct random colors.}

\item{cyl_sides}{The number of sides in the polygon cross section. Defaults to 8, but can be increased to improve visual smoothness.}

\item{clouds}{A list of point cloud data frames where the first three columns are the x, y, and z coordinates in the same coordinate system as the QSMs.}

\item{pt_colors}{A vector of hex colors. Defaults to the same random color as the QSM.}

\item{pt_sizes}{Size of the points as a number. Defaults to 0.1.}

\item{axes}{Show plot axes. Defaults to TRUE.}
}
\value{
A rgl QSM plot
}
\description{
Plots multiple QSMs in a forest stand using the rgl library
}
\examples{
\donttest{

# Import QSMs
file1 <- system.file("extdata/QSM.mat", package = "rTwig")
qsm <- import_qsm(file1)
cylinder <- qsm$cylinder
cylinder <- update_cylinders(cylinder)

# Create a list of QSM cylinder data frames
qsms <- list(cylinder)

# Optionally import and create a list of point clouds
file2 <- system.file("extdata/cloud.txt", package = "rTwig")
cloud <- read.table(file2, header = FALSE)
clouds <- list(cloud)

# Plot QSMs and clouds
plot_stand(qsms = qsms, clouds = clouds)

}

}
