% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulater.R
\name{sim_cor}
\alias{sim_cor}
\title{Simulate correlated normally distributed data}
\usage{
sim_cor(n, rho, means, sds, exact = FALSE)
}
\arguments{
\item{n}{The number of values to simulate (i.e., the number of rows in the simulated data)}

\item{rho}{A vector of correlations to apply to the columns of the simulated data. The number of values should be equal to one or to the number of combinations of variables to be simulated}

\item{means}{A vector of means. The number of values should be equal to the number of variables to simulate}

\item{sds}{A vector of standard deviations. The number of values should be equal to the number of variables to simulate}

\item{exact}{A logical that indicates if the inputs should be interpreted as population of sample characteristics}
}
\value{
A data.frame with the simulated data
}
\description{
Simulate correlated normally distributed data
}
\examples{
sim <- sim_cor(100, .74, c(0, 10), c(1, 5), exact = TRUE)
cor(sim)
sim_summary(sim)

}
