% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/store.R
\name{ragnar_store_update}
\alias{ragnar_store_update}
\title{Inserts or updates chunks in a \code{RagnarStore}}
\usage{
ragnar_store_update(store, chunks)
}
\arguments{
\item{store}{a \code{RagnarStore} object}

\item{chunks}{a character vector or a dataframe with a \code{text} column, and
optionally, a pre-computed \code{embedding} matrix column. If \code{embedding} is not
present, then \code{store@embed()} is used. \code{chunks} can also be a character
vector.}
}
\value{
\code{store}, invisibly.
}
\description{
Inserts or updates chunks in a \code{RagnarStore}
}
\details{
\code{chunks} must be a data frame containing \code{origin} and \code{hash} columns.
We first filter out chunks for which \code{origin} and \code{hash} are already in the store.
If an \code{origin} is in the store, but with a different \code{hash}, we all of its chunks
with the new chunks. Otherwise, a regular insert is performed.

This can help spending less time computing embeddings for chunks that are already in the store.
}
