/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.exponentialfamily;

import eu.amidst.core.distribution.UnivariateDistribution;
import eu.amidst.core.exponentialfamily.EF_UnivariateDistribution;
import eu.amidst.core.exponentialfamily.SufficientStatistics;
import eu.amidst.core.utils.SparseVectorDefaultValue;
import eu.amidst.core.utils.Vector;
import eu.amidst.core.variables.Variable;
import java.util.ArrayList;
import java.util.Random;
import java.util.function.Function;
import org.apache.commons.math3.special.Gamma;

public class EF_SparseDirichlet
extends EF_UnivariateDistribution {
    int nOfStates;

    public EF_SparseDirichlet(Variable var1) {
        if (!var1.isSparseDirichletParameter()) {
            throw new IllegalArgumentException("Non Dirichlet var");
        }
        this.var = var1;
        this.nOfStates = this.var.getNumberOfStates();
        this.naturalParameters = this.createZeroNaturalParameters();
        this.momentParameters = this.createZeroMomentParameters();
        this.parents = new ArrayList();
        this.getSparseNaturalParameters().setDefaultValue(1.0);
        this.fixNumericalInstability();
        this.updateMomentFromNaturalParameters();
    }

    public EF_SparseDirichlet(Variable var1, double scale) {
        if (!var1.isSparseDirichletParameter()) {
            throw new IllegalArgumentException("The variable is not a sparse Dirichlet parameter!");
        }
        this.var = var1;
        this.nOfStates = this.var.getNumberOfStates();
        this.naturalParameters = this.createZeroNaturalParameters();
        this.momentParameters = this.createZeroMomentParameters();
        this.parents = new ArrayList();
        this.getSparseNaturalParameters().setDefaultValue(scale - 1.0);
        this.fixNumericalInstability();
        this.updateMomentFromNaturalParameters();
    }

    private SparseVectorDefaultValue getSparseNaturalParameters() {
        return (SparseVectorDefaultValue)this.naturalParameters;
    }

    private SparseVectorDefaultValue getSparseMomentParameters() {
        return (SparseVectorDefaultValue)this.momentParameters;
    }

    @Override
    public double computeLogBaseMeasure(double val) {
        return 0.0;
    }

    @Override
    public SufficientStatistics getSufficientStatistics(double val) {
        SufficientStatistics vec = this.createZeroSufficientStatistics();
        vec.set((int)val, Math.log(val));
        return vec;
    }

    @Override
    public Vector getExpectedParameters() {
        double sum = this.naturalParameters.sum() + (double)this.naturalParameters.size();
        SparseVectorDefaultValue vector = new SparseVectorDefaultValue(this.nOfStates, 0.0);
        vector.copy(this.naturalParameters);
        vector.sumConstant(1.0);
        vector.divideBy(sum);
        return vector;
    }

    @Override
    public void fixNumericalInstability() {
    }

    @Override
    public EF_UnivariateDistribution deepCopy(Variable var) {
        EF_SparseDirichlet copy = new EF_SparseDirichlet(var);
        copy.getNaturalParameters().copy(this.getNaturalParameters());
        copy.getMomentParameters().copy(this.getMomentParameters());
        return copy;
    }

    @Override
    public EF_UnivariateDistribution randomInitialization(Random random) {
        for (int i = 0; i < this.nOfStates; ++i) {
            this.getNaturalParameters().set(i, 5.0 * random.nextDouble() + 1.0 + 1.0E-5);
        }
        this.fixNumericalInstability();
        this.updateMomentFromNaturalParameters();
        return this;
    }

    @Override
    public <E extends UnivariateDistribution> E toUnivariateDistribution() {
        throw new UnsupportedOperationException("Dirichlet is not included yet in the Distributions package.");
    }

    @Override
    public void updateNaturalFromMomentParameters() {
        throw new UnsupportedOperationException("No Implemented. EF_Dirichlet distribution should (right now) only be used for learning.");
    }

    @Override
    public void updateMomentFromNaturalParameters() {
        final double sumOfU_i = this.naturalParameters.sum();
        this.momentParameters = this.createZeroMomentParameters();
        this.momentParameters.copy(this.naturalParameters);
        this.getSparseMomentParameters().apply(new Function<Double, Double>(){

            @Override
            public Double apply(Double aDouble) {
                return Gamma.digamma(aDouble) - Gamma.digamma(sumOfU_i);
            }
        });
    }

    @Override
    public int sizeOfSufficientStatistics() {
        return this.nOfStates;
    }

    @Override
    public double computeLogNormalizer() {
        double sumOfU_i = this.naturalParameters.sum();
        double sumLogGammaOfU_i = this.getSparseNaturalParameters().sumApply(new Function<Double, Double>(){

            @Override
            public Double apply(Double aDouble) {
                return Gamma.logGamma(aDouble);
            }
        });
        return sumLogGammaOfU_i - Gamma.logGamma(sumOfU_i);
    }

    @Override
    public Vector createZeroVector() {
        return new SparseVectorDefaultValue(this.nOfStates, 0.0);
    }

    @Override
    public SufficientStatistics createInitSufficientStatistics() {
        return new SparseVectorDefaultValue(this.nOfStates, Gamma.digamma(1.0) - Gamma.digamma(this.sizeOfSufficientStatistics()));
    }
}

