% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assess.R, R/desScores.R
\docType{methods}
\name{summary}
\alias{summary}
\alias{summary}
\alias{summary,assessment-method}
\alias{summary}
\alias{summary}
\alias{summary,desScores-method}
\title{Summary of assessments of a randomization procedure}
\usage{
summary(object, ...)

\S4method{summary}{assessment}(object)

summary(object, ...)

\S4method{summary}{desScores}(object)
}
\arguments{
\item{object}{assessment object.}

\item{...}{additional arguments affecting the summary that will be produced.}
}
\value{
Data frame with a summary of the assessment object.

Data frame with a summary of the desirability scores object.
}
\description{
Summary of assessments of a randomization procedure

Summary of desirability scores of a randomization procedure
}
\details{
For each issue the assessment of the sequences is summarized to permit a design-based 
assessment of the randomization procedure.
This approach uses the sequence-wise values of the assessment and the probabilities
in order to give an overall summary.

For each issue the desirability score of the sequences is summarized to permit a 
design-based desirability score of the randomization procedure.
This approach uses the sequence-wise values of the desirability and the probabilities
in order to give an overall summary.
}
\examples{
# assess the full set of PBR(4)
seq <- getAllSeq(pbrPar(4))
issue <- corGuess("CS")
A <- assess(seq, issue)
summary(A)

# Compute the desirability scores of the full set of PBR(4)
seq <- getAllSeq(pbrPar(4))
issue1 <- corGuess("CS")
issue2 <- corGuess("DS")
A <- assess(seq, issue1, issue2)
d1 <- derFunc(0.5, c(0.1, 0.8), c(1, 1))
d2 <- derFunc(0.1, 0.7, 2)
D <- getDesScores(A, d1, d2, weights = c(5/6, 1/6))
summary(D)

}
