% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randSeq.R, R/abcdSeq.R, R/bbcdSeq.R,
%   R/bsdSeq.R, R/chenSeq.R, R/crSeq.R, R/ebcSeq.R, R/gbcdSeq.R, R/hadaSeq.R,
%   R/mpSeq.R, R/pbrSeq.R, R/rarSeq.R, R/tbdSeq.R, R/udSeq.R
\name{getProbabilities}
\alias{getProbabilities}
\alias{calculateProbabilities}
\alias{calcProb}
\alias{getProb}
\alias{getProb,abcdSeq-method}
\alias{getProb,bbcdSeq-method}
\alias{getProb,bsdSeq-method}
\alias{getProb,chenSeq-method}
\alias{getProb,crSeq-method}
\alias{getProb,ebcSeq-method}
\alias{getProb,gbcdSeq-method}
\alias{getProb,hadaSeq-method}
\alias{getProb,mpSeq-method}
\alias{getProb,pbrSeq-method}
\alias{getProb,rarSeq-method}
\alias{getProb,tbdSeq-method}
\alias{getProb,udSeq-method}
\title{Theoretical probability for randomization sequences}
\usage{
getProb(obj)

\S4method{getProb}{abcdSeq}(obj)

\S4method{getProb}{bbcdSeq}(obj)

\S4method{getProb}{bsdSeq}(obj)

\S4method{getProb}{chenSeq}(obj)

\S4method{getProb}{crSeq}(obj)

\S4method{getProb}{ebcSeq}(obj)

\S4method{getProb}{gbcdSeq}(obj)

\S4method{getProb}{hadaSeq}(obj)

\S4method{getProb}{mpSeq}(obj)

\S4method{getProb}{pbrSeq}(obj)

\S4method{getProb}{rarSeq}(obj)

\S4method{getProb}{tbdSeq}(obj)

\S4method{getProb}{udSeq}(obj)
}
\arguments{
\item{obj}{object of a class inheriting from randSeq. Formal representation
of a randomization sequences together with the parameters that belong to
the procedure that generated the sequences.}
}
\value{
a matrix with theoretical probabilities for
observed randomization sequences
}
\description{
Calculate theoretical probability for observed randomization sequences
}
\examples{
myPar <- bsdPar(10, 2)
M <- genSeq(myPar, 2)
getProb(M)

# all Sequences
par <- pbrPar(bc=c(2,2))
refSet <- getAllSeq(myPar)
probs <- getProb(refSet)

# sequences with probabilities
cbind(probs, refSet$M)

}
