% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importance.R
\name{importance_pvalues}
\alias{importance_pvalues}
\title{ranger variable importance confidence intervals and p-values}
\usage{
importance_pvalues(x, method = c("janitza", "altmann"), conf.level = 0.95,
  num.permutations = 100, formula = NULL, data = NULL, ...)
}
\arguments{
\item{x}{ranger or holdoutRF object.}

\item{method}{Method to compute p-values. Use "janitza" for the method by Janitza et al. (2015) or "altmann" for the non-parametric method by Altmann et al. (2010).}

\item{conf.level}{Confidence level for confidence intervals.}

\item{num.permutations}{Number of permutations. Used in the "altmann" method only.}

\item{formula}{Object of class formula or character describing the model to fit. Used in the "altmann" method only.}

\item{data}{Training data of class data.frame or matrix. Used in the "altmann" method only.}

\item{...}{Further arguments passed to ranger(). Used in the "altmann" method only.}
}
\value{
Variable importance, confidence intervals and p-values.
}
\description{
Compute variable importance with confidence intervals and p-values.
}
\author{
Marvin N. Wright
}
\references{
Janitza, S., Celik, E. & Boulesteix, A.-L., (2015). A computationally fast variable importance test for random forest for high dimensional data, Technical Report 185, University of Munich, \url{https://epub.ub.uni-muenchen.de/25587}. \cr
  Altmann, A., Tolosi, L., Sander, O. & Lengauer, T. (2010). Permutation importance: a corrected feature importance measure, Bioinformatics 26(10):1340-1347.
}
\seealso{
\code{\link{ranger}}
}

