% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/rankdist.R
\docType{class}
\name{RankData-class}
\alias{RankData}
\alias{RankData-class}
\title{RankData Class}
\description{
A S4 class to represent ranking data

It is well understood that the ranking representation and ordering representation of ranking data can easily get confused.
I thus use a S4 class to store all the information about the ranking data. This can avoid unnessary confusions.
}
\section{Slots}{

\describe{
\item{\code{nobj}}{an number to store number of ranked objects.}

\item{\code{nobs}}{the number of observations.}

\item{\code{ndistinct}}{the number of distinct rankings.}

\item{\code{ordering}}{a matrix that stores the ordering representation of distinct rankings. Each row contains one ordering.}

\item{\code{ranking}}{a matrix that stores the ranking representation of distinct rankings. Each row contains one ranking.}

\item{\code{count}}{the number of observations for each distinct ranking.}

\item{\code{topq}}{an integer to store whether the data set is top-q ranking. If value is -1, the data is complete rankings.
Otherwise, the value is number of ranked object (the q in top-q ranking).}
}}
\examples{
# creating a random rank data set
rankmat = replicate(10,sample(1:52,52), simplify = "array")
ordermat = OrderingToRanking(rankmat)
countvec = sample(1:52,52,replace=TRUE)
rankdat = new("RankData",nobj=52,nobs=sum(countvec),ndistinct=10,
     ranking=rankmat,ordering=ordermat,count=countvec)
}
\seealso{
\code{\link{RankInit}}, \code{\link{RankControl}}
}

