% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psi.R
\name{psi}
\alias{psi}
\title{Normalizing constant function of a Mallows distribution, psi}
\usage{
psi(theta, J, R, log = FALSE)
}
\arguments{
\item{theta}{A numeric entry specifying the Mallows scale parameter.}

\item{J}{A numeric entry or vector of positive integers indicating total number of objects each judge has access to.
If \code{length(J)>1}, \code{R} must be of same length or a single value.}

\item{R}{A numeric entry or vector of positive integers indicating the length of the ranking provided by each judge.
If \code{length(R)>1}, \code{J} must be of same length or a single value.}

\item{log}{A boolean indicating if \code{log(psi)} should be returned.}
}
\value{
A numeric value or vector representing normalizing constant of a Mallows distribution.
}
\description{
This function calculates the normalizing constant of a Mallows distribution under the Kendall distance
}
\examples{
psi(theta=1,J=10,R=8)
psi(theta=2,J=c(4,4,3),R=c(2,2,1),log=TRUE)

}
