\name{Compare-methods}

\docType{methods}

\alias{Compare-methods}
\alias{==,BasicRaster,BasicRaster-method}
\alias{!=,BasicRaster,BasicRaster-method}

\title{Compare Raster* objects}
\description{
These methods compare the location and resolution of Raster* objects. That is, they compare their spatial extent, projection, and number of rows and columns. 
 
For \code{BasicRaster} objects you can use \code{==} and \code{!=}, the values returned is a single logical value \code{TRUE} or \code{FALSE}
 
For RasterLayer objects, they also compare the values associated with the objects, and the result is a logical (Boolean) RasterLayer object. And the value returned is a RasterLayer object, if the location and resolution of the two RasterLayers match, or an error of they do not match.
 
The following methods have been implemented for RasterLayer objects:
 
 \code{==, !=, >, <,  <=, >=}
}

\section{details}{
If the values of the output RasterLayer cannot be held in memory, they will be saved to a temporary file unless a default filename has been set with \code{link[raster]{rasterOptions}}. You can also use \code{link[raster]{rasterOptions}} to set the format, datatype and overwrite options.
}


\value{
A logical value or a RasterLayer object, and in some cases the side effect of a new file on disk.
}

\author{Robert J. Hijmans }


\examples{
r1 <- raster()
r1 <- setValues(r1, round(10 * runif(ncell(r1))))
r2 <- setValues(r1, round(10 * runif(ncell(r1))))
as(r1, 'BasicRaster') == as(r2, 'BasicRaster')
r3 <- r1 == r2

b <- extent(0, 360, 0, 180)
r4 <- setExtent(r2, b)
as(r2, 'BasicRaster') != as(r4, 'BasicRaster')
# The following would give an error. You cannot compare RasterLayer object that do not have the same BasicRaster properties.
#r3 <- r1 > r4
}


\keyword{methods}
\keyword{math}
