% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotRasterly.R
\name{plotRasterly}
\alias{plotRasterly}
\title{plotRasterly}
\usage{
plotRasterly(
  data = NULL,
  mapping = aes(),
  ...,
  plot_width = 400,
  plot_height = 400,
  x_range = NULL,
  y_range = NULL,
  background = "white",
  color = NULL,
  show_raster = TRUE,
  drop_data = FALSE,
  variable_check = FALSE,
  alpha = 0.5,
  shape = 19,
  point_size = 0.5,
  as_image = FALSE,
  sizing = c("stretch", "fill", "contain")
)
}
\arguments{
\item{data}{Dataset to use for generating the plot. If not provided, data must be supplied in each layer of the plot.
For best performance, particularly when processing large datasets, use of \link[data.table]{data.table} is recommended.}

\item{mapping}{Default list of aesthetic mappings to use for plot. The same with \code{ggplot2} \link[ggplot2]{aes}.
See details.}

\item{...}{Other arguments which will be passed through to layers.}

\item{plot_width}{Integer. The width of the image to plot; must be a positive integer. A higher value indicates a higher resolution.}

\item{plot_height}{Integer. The height of the image to plot; must be a positive integer. A higher value indicates a higher resolution.}

\item{x_range}{Vector of type numeric. The range of \code{x}; it can be used to clip the image. For larger datasets, providing \code{x_range}
may result in improved performance.}

\item{y_range}{Vector of type numeric. The range of \code{y}; it can be used to clip the image. For larger datasets, providing \code{y_range}
may result in improved performance.}

\item{background}{Character. The background color of the image to plot.}

\item{color}{Vector of type character. It will determine this color vector is a \code{color_map} or \code{color_key} automatically.
\itemize{
 \item{}{color_map: It has Color(s) used to draw each pixel. The \code{color_map} is extended by linear interpolation
independently for RGB. The darkness of the mapped color depends upon the values of the aggregation matrix.
 }
 \item{}{color_key: Vector of type character. The \code{color_key} is used for categorical variables; 
 it is passed when the \code{color} aesthetic is provided.
}
}}

\item{show_raster}{Logical. Should the raster be displayed?}

\item{drop_data}{Logical. When working with large datasets, drops the original data once processed according to the provided
\code{aes()} parameters, using the \code{remove()} function. See details for additional information.}

\item{variable_check}{Logical. If \code{TRUE}, drops unused columns to save memory; may result in reduced performance.}

\item{alpha}{The transparency of points, from 0 to 1.}

\item{shape}{The shape of points, see \link{pch}.}

\item{point_size}{The size of points.}

\item{as_image}{Logical value. If \code{FALSE}, image raster will be transformed into a data frame, hence a points layer
would be pipped on \code{plotly}; conversely, a raster layer will be added.}

\item{sizing}{It affects only with \code{as_image = TRUE}. Specifies which dimension of the image to constrain.
One of "stretch" "fill", "contain". see https://plot.ly/r/reference/#Layout_and_layout_style_objects}
}
\value{
a \code{plotly} widget
}
\description{
Display large data set in \code{plotly}
}
\examples{
\dontrun{
 library(rasterly)
 if(requireNamespace("plotly") && 
    requireNamespace("data.table") && 
    requireNamespace("lubridate")) {
   # Load data
 url1 <- "https://raw.githubusercontent.com/plotly/datasets/master/uber-rides-data1.csv"
 ridesRaw_1 <-  url1 \%>\%
   data.table::fread(stringsAsFactors = FALSE)
 url2 <- "https://raw.githubusercontent.com/plotly/datasets/master/uber-rides-data2.csv"
 ridesRaw_2 <-  url2 \%>\%
   data.table::fread(stringsAsFactors = FALSE)
 url3 <- "https://raw.githubusercontent.com/plotly/datasets/master/uber-rides-data3.csv"
 ridesRaw_3 <-  url3 \%>\%
   data.table::fread(stringsAsFactors = FALSE) 
 ridesDf <- list(ridesRaw_1, ridesRaw_2, ridesRaw_3) \%>\% 
   data.table::rbindlist()
       
 time <- lubridate::ymd_hms(ridesDf$`Date/Time`)
 ridesDf <-  
   ridesDf[, 'Date/Time':=NULL][, list(Lat, 
              Lon,                                               
              hour = lubridate::hour(time),                                                
              month = lubridate::month(time),
              day = lubridate::day(time))]
 # A point layer is added
 plotRasterly(data = ridesDf, 
              mapping = aes(x = Lat, y = Lon, color = hour),
              color = hourColors_map,
              as_image = FALSE)
  # An image layer is added       
  plotRasterly(data = ridesDf, 
               mapping = aes(x = Lat, y = Lon, color = hour),
               color = hourColors_map,
               as_image = TRUE)
  
 }
}
}
\seealso{
\code{\link{ggRasterly}}, \code{\link{plot.rasterly}}
}
