% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme-atlas.R
\name{theme_atlas}
\alias{theme_atlas}
\title{ATLAS ggplot2 theme for consistent graphics}
\usage{
theme_atlas(
  base_family = "Arial Narrow",
  base_size = 11.5,
  axis_text_size = 9,
  axis_title_size = base_size,
  axis_title_just = "cm",
  ...
)
}
\arguments{
\item{base_family, base_size}{base font family and size}

\item{axis_text_size}{font size of axis text}

\item{axis_title_size}{axis title font family, face and size}

\item{axis_title_just}{axis title font justification, one of \verb{[blmcrt]}}

\item{...}{Additional arguments passed to \code{\link[hrbrthemes:theme_ipsum]{hrbrthemes::theme_ipsum()}}.}
}
\value{
A theme for use in plots created with \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}.
}
\description{
Based on \code{hrbrthemes::\link[hrbrthemes]{theme_ipsum}}.
}
\examples{
\dontrun{
library(ggplot2)
library(dplyr)

# seminal scatterplot
ggplot(mtcars, aes(mpg, wt)) +
  geom_point() +
  labs(x = "Fuel effiiency (mpg)", y = "Weight (tons)",
       title = "Seminal ggplot2 scatterplot example",
       subtitle = "A plot that is only useful for demonstration purposes",
       caption = "Brought to you by the letter 'g'") +
  theme_atlas()

# seminal bar chart

update_geom_font_defaults()

count(mpg, class) \%>\%
  ggplot(aes(class, n)) +
  geom_col() +
  geom_text(aes(label=n), nudge_y=3) +
  labs(x = "Fuel efficiency (mpg)", y = "Weight (tons)",
       title =  "Seminal ggplot2 bar chart example",
       subtitle = "A plot that is only useful for demonstration purposes",
       caption = "Brought to you by the letter 'g'") +
  theme_atlas(grid = "Y") +
  theme(axis.text.y = element_blank())
  }
}
