% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tensor-baseline-voltage.R
\name{voltage_baseline}
\alias{voltage_baseline}
\alias{voltage_baseline.rave_prepare_subject_raw_voltage_with_epoch}
\alias{voltage_baseline.rave_prepare_subject_voltage_with_epoch}
\alias{voltage_baseline.FileArray}
\alias{voltage_baseline.array}
\title{Calculate voltage baseline}
\usage{
voltage_baseline(
  x,
  baseline_windows,
  method = c("percentage", "zscore", "subtract_mean"),
  units = c("Trial", "Electrode"),
  ...
)

\method{voltage_baseline}{rave_prepare_subject_raw_voltage_with_epoch}(
  x,
  baseline_windows,
  method = c("percentage", "zscore", "subtract_mean"),
  units = c("Trial", "Electrode"),
  electrodes,
  baseline_mean,
  baseline_sd,
  ...
)

\method{voltage_baseline}{rave_prepare_subject_voltage_with_epoch}(
  x,
  baseline_windows,
  method = c("percentage", "zscore", "subtract_mean"),
  units = c("Trial", "Electrode"),
  electrodes,
  baseline_mean,
  baseline_sd,
  ...
)

\method{voltage_baseline}{FileArray}(
  x,
  baseline_windows,
  method = c("percentage", "zscore", "subtract_mean"),
  units = c("Trial", "Electrode"),
  filebase = NULL,
  ...
)

\method{voltage_baseline}{array}(
  x,
  baseline_windows,
  method = c("percentage", "zscore", "subtract_mean"),
  units = c("Trial", "Electrode"),
  ...
)
}
\arguments{
\item{x}{R array, \code{\link[filearray]{filearray}}, or
\code{'rave_prepare_power'} object created by
\code{\link{prepare_subject_raw_voltage_with_epoch}}.}

\item{baseline_windows}{list of baseline window (intervals)}

\item{method}{baseline method; choices are \code{'percentage'} and
\code{'zscore'}; see 'Details' in \code{\link[dipsaus]{baseline_array}}}

\item{units}{the unit of the baseline; see 'Details'}

\item{...}{passed to other methods}

\item{electrodes}{the electrodes to be included in baseline calculation;
for power repository object produced by \code{\link{prepare_subject_power}}
only; default is all available electrodes in each of \code{signal_types}}

\item{baseline_mean, baseline_sd}{internally used by 'RAVE' repository,
provided baseline is not contained in the data. This is useful for
calculating the baseline with data from other blocks.}

\item{filebase}{where to store the output; default is \code{NULL} and is
automatically determined}
}
\value{
The same type as the inputs
}
\description{
Calculate voltage baseline
}
\details{
The arrays must be three-mode tensor and must have valid named
\code{\link{dimnames}}. The dimension names must be \code{'Trial'},
\code{'Time'}, \code{'Electrode'}, case sensitive.

The \code{baseline_windows} determines the baseline windows that are used to
calculate time-points of baseline to be included. This can be one
or more intervals and must pass the validation function
\code{\link{validate_time_window}}.

The \code{units} determines the unit of the baseline. It can be either or
both of \code{'Trial'}, \code{'Electrode'}. The default
value is both, i.e., baseline for each combination of trial and electrode.
}
\examples{

\dontrun{
# The following code need to download additional demo data
# Please see https://rave.wiki/ for more details

library(raveio)
repo <- prepare_subject_raw_voltage_with_epoch(
  subject = "demo/DemoSubject",
  time_windows = c(-1, 3),
  electrodes = c(14, 15))

##### Direct baseline on repository
voltage_baseline(
  x = repo, method = "zscore",
  baseline_windows = list(c(-1, 0), c(2, 3))
)

voltage_mean <- repo$raw_voltage$baselined$collapse(
  keep = c(1,3), method = "mean")
matplot(voltage_mean, type = "l", lty = 1,
        x = repo$raw_voltage$dimnames$Time,
        xlab = "Time (s)", ylab = "Voltage (z-scored)",
        main = "Mean coltage over trial (Baseline: -1~0 & 2~3)")
abline(v = 0, lty = 2, col = 'darkgreen')
text(x = 0, y = -0.5, "Aud-Onset ", col = "darkgreen", cex = 0.6, adj = c(1,1))

##### Alternatively, baseline on each electrode channel
voltage_mean2 <- sapply(repo$raw_voltage$data_list, function(inst) {
  re <- voltage_baseline(
    x = inst, method = "zscore",
    baseline_windows = list(c(-1, 0), c(2, 3)))
  rowMeans(re[])
})

# Same with floating difference
max(abs(voltage_mean - voltage_mean2)) < 1e-8


}

}
